;   Copyright (C) 2016 Free Software Foundation, Inc.
;   Contributed by Alex Panek.
;
; This file is free software; you can redistribute it and/or modify it
; under the terms of the GNU General Public License as published by the
; Free Software Foundation; either version 3, or (at your option) any
; later version.
;
; This file is distributed in the hope that it will be useful, but
; WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
; General Public License for more details.
;
; Under Section 7 of GPL version 3, you are granted additional
; permissions described in the GCC Runtime Library Exception, version
; 3.1, as published by the Free Software Foundation.
;
; You should have received a copy of the GNU General Public License and
; a copy of the GCC Runtime Library Exception along with this program;
; see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see
; <http://www.gnu.org/licenses/>.


#include "vregs.h"

    .text


;;   int __ucmpdi2 (uint64_t A, uint64_t B)
;;
;; Performs an unsigned comparison of A and B.
;; If A is less than B it returns 0.  If A is greater
;; than B it returns 2.  If they are equal it returns 1.

START_FUNC ___ucmpdi2
    movw   hl, sp

    movw   ax, [hl+10]
    cmpw   ax, [hl+18]

0:  onew   ax
    movw   r8, ax ;; init ( r8 = 1 )

    bh     $1f
    bnz    $2f

    movw   ax, [hl+8]
    cmpw   ax, [hl+16]
    bh     $1f
    bnz    $2f

    movw   ax, [hl+6]
    cmpw   ax, [hl+14]
    bh     $1f
    bnz    $2f

    movw   ax, [hl+4]
    cmpw   ax, [hl+12]
    bh     $1f
    bnz    $2f

    ret        ;; equal ( r8 = 1 )

1:  incw   r8  ;; greater ( r8 = 2 )
    ret

2:  decw   r8  ;; lesser ( r8 = 0 )
    ret

;;   int __cmpdi2 (int64_t A, int64_t B)
;;
;; Performs an signed comparison of A and B.
;; If A is less than B it returns 0.  If A is greater
;; than B it returns 2.  If they are equal it returns 1.

START_ANOTHER_FUNC ___cmpdi2
    movw   hl, sp

    movw   ax, [hl+18]
    movw   bc, ax

    movw   ax, [hl+10]
    cmpw   ax, bc
    xor1   CY, a.7         ; factor in the sign bits of the two operands
    xor1   CY, r_3.7

    br     $0b             ; then jump to the unsigned compare code

END_ANOTHER_FUNC ___cmpdi2

END_FUNC ___ucmpdi2
