;   Copyright (C) 2017 Free Software Foundation, Inc.
;   Contributed by Alex Panek.
;
; This file is free software; you can redistribute it and/or modify it
; under the terms of the GNU General Public License as published by the
; Free Software Foundation; either version 3, or (at your option) any
; later version.
;
; This file is distributed in the hope that it will be useful, but
; WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
; General Public License for more details.
;
; Under Section 7 of GPL version 3, you are granted additional
; permissions described in the GCC Runtime Library Exception, version
; 3.1, as published by the Free Software Foundation.
;
; You should have received a copy of the GNU General Public License and
; a copy of the GCC Runtime Library Exception along with this program;
; see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see
; <http://www.gnu.org/licenses/>.


#include "vregs.h"

    .text

; table entries are 8 bits offsets (unsigned)
; inputs:   AX  = table index (unsigned 16 bit value)
;           BC  = table address (the lower 16 bits)
;           D   = table address (the higher 4 bits)
; clobbers: AX,BC,DE,HL

START_FUNC ___tbljmp_qi_u

    addw   ax, bc
    movw   hl, ax        ; HL lower 16 bits of the table entry
    mov    a,  d
    addc   a,  #0
    mov    es, a
    mov    a,  es:[hl]   ; load the offset from the table
    shrw   ax, 8         ; zero-extend to 16 bits
    addw   ax, bc
    movw   bc, ax
    mov    a,  d
    addc   a,  #0
    shrw   ax, 8
    push   ax
    push   bc
    ret

END_FUNC ___tbljmp_qi_u


; table entries are 8 bits offsets (signed)
; inputs:   AX  = table index (unsigned 16 bit value)
;           BC  = table address (the lower 16 bits)
;           D   = table address (the higher 4 bits)
; clobbers: AX,BC,DE,HL

START_FUNC ___tbljmp_qi

    addw   ax, bc
    movw   hl, ax        ; HL lower 16 bits of the table entry
    mov    a,  d
    addc   a,  #0
    mov    es, a
    mov    a,  es:[hl]   ; load the offset from the table
    sarw   ax, 8         ; sign-extend to 16 bits
    mov    e,  a
    addw   ax, bc
    movw   bc, ax
    mov    a,  d
    addc   a,  e
    and    a,  #15
    shrw   ax, 8
    push   ax
    push   bc
    ret

END_FUNC ___tbljmp_qi


; table entries are 16 bits offsets (unsigned)
; inputs:   AX  = table index (unsigned 16 bit value)
;           BC  = table address (the lower 16 bits)
;           D   = table address (the higher 4 bits)
; clobbers: AX,BC,DE,HL

START_FUNC ___tbljmp_hi_u

    addw   ax, ax        ; convert index to offset
    addw   ax, bc
    movw   hl, ax        ; HL lower 16 bits of the table entry
    mov    a,  d
    addc   a,  #0
    mov    es, a
    movw   ax, es:[hl]   ; load the 16-bit offset from the table
    addw   ax, bc
    movw   bc, ax
    mov    a,  d
    addc   a,  #0
    shrw   ax, 8
    push   ax
    push   bc
    ret

END_FUNC ___tbljmp_hi_u


; table entries are 16 bits offsets (signed)
; inputs:   AX  = table index (unsigned 16 bit value)
;           BC  = table address (the lower 16 bits)
;           D   = table address (the higher 4 bits)
; clobbers: AX,BC,DE,HL

START_FUNC ___tbljmp_hi

    addw   ax, ax        ; convert index to offset
    addw   ax, bc
    movw   hl, ax        ; HL lower 16 bits of the table entry
    mov    a,  d
    addc   a,  #0
    mov    es, a
    movw   ax, es:[hl]   ; load the 16-bit offset from the table
    mov    e,  #0
    mov1   CY, a.7
    sknc
    dec    e
    addw   ax, bc
    movw   bc, ax
    mov    a,  d
    addc   a,  e
    and    a,  #15
    shrw   ax, 8
    push   ax
    push   bc
    ret

END_FUNC ___tbljmp_hi


; table entries are 20(32) bits offsets (signed)
; inputs:   AX  = table index (unsigned 16 bit value)
;           BC  = table address (the lower 16 bits)
;           ES  = table address (the higher 4 bits)
; clobbers: AX,ES,HL

START_FUNC ___tbljmp_si

    shlw   ax, 2         ; convert index to offset
    addw   ax, bc
    movw   hl, ax        ; HL lower 16 bits of the table entry
    mov    a,  d
    addc   a,  #0
    mov    es, a
    movw   ax, es:[hl]   ; load the offset from the table
    addw   ax, bc
    movw   bc, ax        ; the lower 16-bits of the target address
    sknc
    inc    d             ; add possible carry to upper 4 bits
    movw   ax, hl
    addw   ax, #2
    movw   hl, ax        ; get address of upper 4 bits of offset
    mov    a,  es
    addc   a,  #0
    mov    es, a         ; ES might change
    mov    a,  es:[hl]   ; load upper 4 bits of the offset
    add    a,  d         ; get the final 4 bits of the target address
    and    a,  #15
    shrw   ax, 8
    push   ax
    push   bc
    ret

END_FUNC ___tbljmp_si
