/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import processing.app.Base;
import processing.app.Editor;
import processing.app.I18n;
import processing.app.Sketch;
import processing.app.SketchCode;
import processing.app.Theme;
import processing.app.tools.MenuScroller;

public class EditorHeader
extends JComponent {
    static Color backgroundColor;
    static Color[] textColor;
    Editor editor;
    int[] tabLeft;
    int[] tabRight;
    Font font;
    FontMetrics metrics;
    int fontAscent;
    JMenu menu;
    JPopupMenu popup;
    int menuLeft;
    int menuRight;
    static final String[] STATUS;
    static final int UNSELECTED = 0;
    static final int SELECTED = 1;
    static final String[] WHERE;
    static final int LEFT = 0;
    static final int MIDDLE = 1;
    static final int RIGHT = 2;
    static final int MENU = 3;
    static final int PIECE_WIDTH = 4;
    static Image[][] pieces;
    Image offscreen;
    int sizeW;
    int sizeH;
    int imageW;
    int imageH;

    public EditorHeader(Editor eddie) {
        this.editor = eddie;
        if (pieces == null) {
            pieces = new Image[STATUS.length][WHERE.length];
            for (int i = 0; i < STATUS.length; ++i) {
                for (int j = 0; j < WHERE.length; ++j) {
                    String path = "tab-" + STATUS[i] + "-" + WHERE[j] + ".gif";
                    EditorHeader.pieces[i][j] = Base.getThemeImage(path, this);
                }
            }
        }
        if (backgroundColor == null) {
            backgroundColor = Theme.getColor("header.bgcolor");
            EditorHeader.textColor[1] = Theme.getColor("header.text.selected.color");
            EditorHeader.textColor[0] = Theme.getColor("header.text.unselected.color");
        }
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int x = e.getX();
                int y = e.getY();
                if (x > EditorHeader.this.menuLeft && x < EditorHeader.this.menuRight) {
                    EditorHeader.this.popup.show(EditorHeader.this, x, y);
                } else {
                    Sketch sketch = EditorHeader.this.editor.getSketch();
                    for (int i = 0; i < sketch.getCodeCount(); ++i) {
                        if (x <= EditorHeader.this.tabLeft[i] || x >= EditorHeader.this.tabRight[i]) continue;
                        sketch.setCurrentCode(i);
                        EditorHeader.this.repaint();
                    }
                }
            }
        });
    }

    @Override
    public void paintComponent(Graphics screen) {
        if (screen == null) {
            return;
        }
        Sketch sketch = this.editor.getSketch();
        if (sketch == null) {
            return;
        }
        Dimension size = this.getSize();
        if (size.width != this.sizeW || size.height != this.sizeH) {
            if (size.width > this.imageW || size.height > this.imageH) {
                this.offscreen = null;
            } else {
                this.sizeW = size.width;
                this.sizeH = size.height;
            }
        }
        if (this.offscreen == null) {
            this.sizeW = size.width;
            this.sizeH = size.height;
            this.imageW = this.sizeW;
            this.imageH = this.sizeH;
            this.offscreen = this.createImage(this.imageW, this.imageH);
        }
        Graphics g = this.offscreen.getGraphics();
        if (this.font == null) {
            this.font = Theme.getFont("header.text.font");
        }
        g.setFont(this.font);
        this.metrics = g.getFontMetrics();
        this.fontAscent = this.metrics.getAscent();
        g.setColor(backgroundColor);
        g.fillRect(0, 0, this.imageW, this.imageH);
        int codeCount = sketch.getCodeCount();
        if (this.tabLeft == null || this.tabLeft.length < codeCount) {
            this.tabLeft = new int[codeCount];
            this.tabRight = new int[codeCount];
        }
        int x = 6;
        for (int i = 0; i < sketch.getCodeCount(); ++i) {
            SketchCode code = sketch.getCode(i);
            String codeName = sketch.hideExtension(code.getExtension()) ? code.getPrettyName() : code.getFileName();
            String text = "  " + codeName + (code.isModified() ? " \u00a7" : "  ");
            Graphics2D g2 = (Graphics2D)g;
            int textWidth = (int)this.font.getStringBounds(text, g2.getFontRenderContext()).getWidth();
            int pieceCount = 2 + textWidth / 4;
            int pieceWidth = pieceCount * 4;
            int state = code == sketch.getCurrentCode() ? 1 : 0;
            g.drawImage(pieces[state][0], x, 0, null);
            int contentLeft = x += 4;
            this.tabLeft[i] = x;
            for (int j = 0; j < pieceCount; ++j) {
                g.drawImage(pieces[state][1], x, 0, null);
                x += 4;
            }
            this.tabRight[i] = x;
            int textLeft = contentLeft + (pieceWidth - textWidth) / 2;
            g.setColor(textColor[state]);
            int baseline = (this.sizeH + this.fontAscent) / 2;
            g.drawString(text, textLeft, baseline);
            g.drawImage(pieces[state][2], x, 0, null);
            x += 3;
        }
        this.menuLeft = this.sizeW - (16 + pieces[0][3].getWidth(this));
        this.menuRight = this.sizeW - 16;
        g.drawImage(pieces[this.popup.isVisible() ? 1 : 0][3], this.menuLeft, 0, null);
        screen.drawImage(this.offscreen, 0, 0, null);
    }

    public void rebuild() {
        this.rebuildMenu();
        this.repaint();
        Toolkit.getDefaultToolkit().sync();
    }

    public void rebuildMenu() {
        if (this.menu != null) {
            this.menu.removeAll();
        } else {
            this.menu = new JMenu();
            MenuScroller.setScrollerFor(this.menu);
            this.popup = this.menu.getPopupMenu();
            this.add(this.popup);
            this.popup.setLightWeightPopupEnabled(true);
        }
        JMenuItem item = Editor.newJMenuItemShift(I18n._("New Tab"), 78);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditorHeader.this.editor.getSketch().handleNewCode();
            }
        });
        this.menu.add(item);
        item = new JMenuItem(I18n._("Rename"));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditorHeader.this.editor.getSketch().handleRenameCode();
            }
        });
        this.menu.add(item);
        item = new JMenuItem(I18n._("Delete"));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditorHeader.this.editor.getSketch().handleDeleteCode();
            }
        });
        this.menu.add(item);
        this.menu.addSeparator();
        item = new JMenuItem(I18n._("Previous Tab"));
        KeyStroke ctrlAltLeft = KeyStroke.getKeyStroke(37, Editor.SHORTCUT_ALT_KEY_MASK);
        item.setAccelerator(ctrlAltLeft);
        this.menu.add(item);
        item = new JMenuItem(I18n._("Next Tab"));
        KeyStroke ctrlAltRight = KeyStroke.getKeyStroke(39, Editor.SHORTCUT_ALT_KEY_MASK);
        item.setAccelerator(ctrlAltRight);
        this.menu.add(item);
        Sketch sketch = this.editor.getSketch();
        if (sketch != null) {
            this.menu.addSeparator();
            ActionListener jumpListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditorHeader.this.editor.getSketch().setCurrentCode(e.getActionCommand());
                }
            };
            for (SketchCode code : sketch.getCode()) {
                item = new JMenuItem(code.isExtension(sketch.getDefaultExtension()) ? code.getPrettyName() : code.getFileName());
                item.setActionCommand(code.getFileName());
                item.addActionListener(jumpListener);
                this.menu.add(item);
            }
        }
    }

    public void deselectMenu() {
        this.repaint();
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    @Override
    public Dimension getMinimumSize() {
        if (Base.isMacOS()) {
            return new Dimension(300, 33);
        }
        return new Dimension(300, 32);
    }

    @Override
    public Dimension getMaximumSize() {
        if (Base.isMacOS()) {
            return new Dimension(3000, 33);
        }
        return new Dimension(3000, 32);
    }

    static {
        textColor = new Color[2];
        STATUS = new String[]{"unsel", "sel"};
        WHERE = new String[]{"left", "mid", "right", "menu"};
    }
}

