/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp.daemon;

import com.sun.jmx.defaults.JmxProperties;
import com.sun.jmx.snmp.SnmpMessage;
import com.sun.jmx.snmp.SnmpPduFactory;
import com.sun.jmx.snmp.SnmpPduPacket;
import com.sun.jmx.snmp.SnmpPduRequest;
import com.sun.jmx.snmp.daemon.SnmpAdaptorServer;
import com.sun.jmx.snmp.daemon.SnmpInformRequest;
import com.sun.jmx.snmp.daemon.SnmpQManager;
import java.net.DatagramPacket;
import java.util.logging.Level;

class SnmpResponseHandler {
    SnmpAdaptorServer adaptor = null;
    SnmpQManager snmpq = null;

    public SnmpResponseHandler(SnmpAdaptorServer snmpAdaptorServer, SnmpQManager snmpQManager) {
        this.adaptor = snmpAdaptorServer;
        this.snmpq = snmpQManager;
    }

    public synchronized void processDatagram(DatagramPacket datagramPacket) {
        block15: {
            byte[] byArray = datagramPacket.getData();
            int n = datagramPacket.getLength();
            if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, SnmpResponseHandler.class.getName(), "action", "processDatagram", "Received from " + datagramPacket.getAddress().toString() + " Length = " + n + "\nDump : \n" + SnmpMessage.dumpHexBuffer(byArray, 0, n));
            }
            try {
                SnmpMessage snmpMessage = new SnmpMessage();
                snmpMessage.decodeMessage(byArray, n);
                snmpMessage.address = datagramPacket.getAddress();
                snmpMessage.port = datagramPacket.getPort();
                SnmpPduFactory snmpPduFactory = this.adaptor.getPduFactory();
                if (snmpPduFactory == null) {
                    if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                        JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpResponseHandler.class.getName(), "processDatagram", "Dropping packet. Unable to find the pdu factory of the SNMP adaptor server");
                    }
                } else {
                    SnmpPduPacket snmpPduPacket = (SnmpPduPacket)snmpPduFactory.decodeSnmpPdu(snmpMessage);
                    if (snmpPduPacket == null) {
                        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpResponseHandler.class.getName(), "processDatagram", "Dropping packet. Pdu factory returned a null value");
                        }
                    } else if (snmpPduPacket instanceof SnmpPduRequest) {
                        SnmpPduRequest snmpPduRequest = (SnmpPduRequest)snmpPduPacket;
                        SnmpInformRequest snmpInformRequest = this.snmpq.removeRequest(snmpPduRequest.requestId);
                        if (snmpInformRequest != null) {
                            snmpInformRequest.invokeOnResponse(snmpPduRequest);
                        } else if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpResponseHandler.class.getName(), "processDatagram", "Dropping packet. Unable to find corresponding for InformRequestId = " + snmpPduRequest.requestId);
                        }
                    } else if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                        JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpResponseHandler.class.getName(), "processDatagram", "Dropping packet. The packet does not contain an inform response");
                    }
                    snmpPduPacket = null;
                }
            }
            catch (Exception exception) {
                if (!JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) break block15;
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpResponseHandler.class.getName(), "processDatagram", "Exception while processsing", exception);
            }
        }
    }
}

