/*
  Andon sample
  
  A0: connect to buzzer.
  
  Add the RTC library.
 
  This example code is in the public domain.
 */
 
#include <RLduino78.h>
#include <RLduino78_RTC.h>

// Pin 22,23,24 are assigned to RGB LEDs.
#define LED_R 22 // LOW active
#define LED_G 23 // LOW active
#define LED_B 24 // LOW active

void ledPattern1();
void ledPattern2();
void ledPattern3();
RTC_TIMETYPE t;

// the setup routine runs once when you press reset:
void setup() {
  setPowerManagementMode(PM_SNOOZE_MODE, 10, 1023); //Set CPU STOP_MODE in delay()
  //setOperationClockMode(CLK_LOW_SPEED_MODE); //Set CPU clock from 32MHz to 32.768kHz

  Serial.begin(9600);
  int err = rtc_init();

  t.year    = 2014;
  t.mon     = 11;
  t.day     = 14;
  t.weekday = RTC_WEEK_SUNDAY;
  t.hour    = 14;
  t.min     = 30;
  t.second  = 0;

  err = rtc_set_time(&t);

  // initialize the digital pin as an output.
  pinMode(LED_R, OUTPUT);
  pinMode(LED_G, OUTPUT);
  pinMode(LED_B, OUTPUT);
  analogWrite(LED_R, 255);
  analogWrite(LED_G, 255);
  analogWrite(LED_B, 255);
}

// the loop routine runs over and over again forever:
void loop() {
  int data;
  data = analogRead(A0);
  ledPattern1();

  data = analogRead(A0);
  ledPattern2();

  data = analogRead(A0);
  ledPattern3();
}

void ledPattern1()
{
  int i;
  analogWrite(LED_G, 254);   // turn the BLUE LED on
  for(i=0; i<250; i+=5)
  {
    analogWrite(LED_B, 255 -i);   // turn the BLUE LED on
    analogWrite(LED_R, 255 -i);   // turn the BLUE LED on
    delay(30);
  }
  for(i=0; i<250; i+=5)
  {
    analogWrite(LED_B, i);   // turn the BLUE LED on
    analogWrite(LED_R, i);   // turn the BLUE LED on
    delay(30);
  }
  digitalWrite(LED_R, HIGH);
  digitalWrite(LED_G, HIGH);
  digitalWrite(LED_B, HIGH);
}

void ledPattern2()
{
  int i, err, week;
  err = rtc_get_time(&t);
  week = t.weekday + 1;

  Serial.print(t.year, DEC);Serial.print("/");
  Serial.print(t.mon, DEC); Serial.print(" ");
  Serial.print(t.hour, DEC); Serial.print(":");
  Serial.print(t.min, DEC); Serial.print(":");
  Serial.println(t.second, DEC);

  for(i=0; i<250; i+=5)
  {
    analogWrite(LED_R, 255 -(i * bitRead(week, 0)));
    analogWrite(LED_G, 255 -(i * bitRead(week, 1)));
    analogWrite(LED_B, 255 -(i * bitRead(week, 2)));
    delay(20);
  }
  digitalWrite(LED_R, 1-(bitRead(week, 0)));
  digitalWrite(LED_G, 1-(bitRead(week, 1)));
  digitalWrite(LED_B, 1-(bitRead(week, 2)));
}

void ledPattern3()
{

  digitalWrite(LED_R, HIGH);
  digitalWrite(LED_G, HIGH);
  digitalWrite(LED_B, HIGH);
  delay(200);
  digitalWrite(LED_R, LOW);
  digitalWrite(LED_G, HIGH);
  digitalWrite(LED_B, HIGH);
  delay(200);

  digitalWrite(LED_R, HIGH);
  digitalWrite(LED_G, LOW);
  digitalWrite(LED_B, HIGH);
  delay(200);

  digitalWrite(LED_R, LOW);
  digitalWrite(LED_G, LOW);
  digitalWrite(LED_B, HIGH);
  delay(200);

  digitalWrite(LED_R, HIGH);
  digitalWrite(LED_G, HIGH);
  digitalWrite(LED_B, LOW);
  delay(200);

  digitalWrite(LED_R, LOW);
  digitalWrite(LED_G, HIGH);
  digitalWrite(LED_B, LOW);
  delay(200);

  digitalWrite(LED_R, HIGH);
  digitalWrite(LED_G, LOW);
  digitalWrite(LED_B, LOW);
  delay(100);

  digitalWrite(LED_R, LOW);
  digitalWrite(LED_G, LOW);
  digitalWrite(LED_B, LOW);
  delay(200);

  digitalWrite(LED_R, HIGH);
  digitalWrite(LED_G, HIGH);
  digitalWrite(LED_B, HIGH);
}
