#include <Arduino.h>
#include <WavMp3p.h>
#include <MsTimer2.h>
#include <SD.h>

#define FILE_PLAY1 "1.mp3"
WavMp3p wavmp3p(44100);
File root;

static void cyclic_handler(void);

void setup()
{
	Serial.begin(9600);
	Serial.println("wav & mp3 player");

	while(!SD.begin())
	{
		Serial.println("Card failed, or not present.");
		delay(1000);
	}

	// for skip and pause
	MsTimer2::set(100, cyclic_handler);
	MsTimer2::start();
}

void loop()
{
	// Play
	wavmp3p.play(FILE_PLAY1);
//	wavmp3p.play(FILE_PLAY1);
	Serial.println("done!");

}

// The below handler enables to skip or stop.
static void cyclic_handler()
{
	if(Serial.available()){
		char c = Serial.read();
		if(c == 'p'){
			if(wavmp3p.read_pause()){
				wavmp3p.pause(0);
			}else{
				wavmp3p.pause(1);
			}
		} else {
			wavmp3p.skip();
		}
	}
}
