;   Copyright (C) 2016 Free Software Foundation, Inc.
;   Contributed by Alex Panek.
;
; This file is free software; you can redistribute it and/or modify it
; under the terms of the GNU General Public License as published by the
; Free Software Foundation; either version 3, or (at your option) any
; later version.
;
; This file is distributed in the hope that it will be useful, but
; WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
; General Public License for more details.
;
; Under Section 7 of GPL version 3, you are granted additional
; permissions described in the GCC Runtime Library Exception, version
; 3.1, as published by the Free Software Foundation.
;
; You should have received a copy of the GNU General Public License and
; a copy of the GCC Runtime Library Exception along with this program;
; see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see
; <http://www.gnu.org/licenses/>.


#include "vregs.h"

//#define USE_ROTLHI_FOR_ROTLRI

    .text

; A(X) - the input/output value
; C    - the number of bits to rotate

START_FUNC ___rotlqi3

    cmp0 c
    bz   $2f
1:
    rol  a, 1
    dec  c
    bnz  $1b
2:
    ret

END_FUNC ___rotlqi3


START_FUNC ___rotrqi3

    cmp0 c
    bz   $2f
1:
    ror  a, 1
    dec  c
    bnz  $1b
2:
    ret

END_FUNC ___rotrqi3


START_FUNC ___rotlhi3

0:  cmp0  c
    bz    $2f
1:
    mov1  CY, a.7
    rolwc ax, 1
    dec   c
    bnz   $1b
2:
    ret

#ifdef USE_ROTLHI_FOR_ROTLRI

START_ANOTHER_FUNC ___rotrhi3

    mov   b, a
    mov   a, #16
    sub   a, c
    mov   c, a
    mov   a, b
    br    $0b

END_ANOTHER_FUNC ___rotrhi3

#endif

END_FUNC ___rotlhi3

#ifndef USE_ROTLHI_FOR_ROTLRI

START_FUNC ___rotrhi3

    cmp0  c
    bz    $2f
1:
    mov1  CY, r_0.0
    shrw  ax, 1
    mov1  a.7, CY
    dec   c
    bnz   $1b
2:
    ret
END_FUNC ___rotrhi3

#endif
