;   Copyright (C) 2016 Free Software Foundation, Inc.
;   Contributed by Alex Panek.
;
; This file is free software; you can redistribute it and/or modify it
; under the terms of the GNU General Public License as published by the
; Free Software Foundation; either version 3, or (at your option) any
; later version.
;
; This file is distributed in the hope that it will be useful, but
; WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
; General Public License for more details.
;
; Under Section 7 of GPL version 3, you are granted additional
; permissions described in the GCC Runtime Library Exception, version
; 3.1, as published by the Free Software Foundation.
;
; You should have received a copy of the GNU General Public License and
; a copy of the GCC Runtime Library Exception along with this program;
; see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see
; <http://www.gnu.org/licenses/>.


#include "vregs.h"

    .text

; HL - address of the destination buffer
; DE - address of the source buffer
; BC - count (may be zero)

START_FUNC ___movmemhi

    push  de
    push  hl

0:  cmp0  c
    bnz   $1f
    cmp0  b
    bz    $2f

1:  mov   a, [de]
    decw  bc
    mov   [hl], a
    incw  de
    incw  hl
    br    $0b

2:  pop   hl
    pop   de

    ret

END_FUNC ___movmemhi
