TARGET = rl78
TYPE = elf
AR := $(TARGET)-$(TYPE)-ar
CC := $(TARGET)-$(TYPE)-gcc
CCOPTS = -W -Wall -Wno-narrowing -Wwrite-strings -Wcast-qual -Wstrict-prototypes -Wmissing-prototypes -Wold-style-definition -Os -ffunction-sections -fdata-sections -O2 -fbuilding-libgcc -fno-stack-protector
ASOPTS = -xassembler-with-cpp
FLAGS1 = -DIN_GCC -DCROSS_DIRECTORY_STRUCTURE -DHAVE_CC_TLS -DUSE_EMUTLS -DIN_LIBGCC2 -Dinhibit_libc
FLAGS2 = -fvisibility=hidden -DHIDE_EXPORTS
FLAGS_EXEP = -fexceptions -fnon-call-exceptions
FLAGS_EXEP2 = -fexceptions
FLAGS_FPBIT = -DFINE_GRAINED_LIBRARIES -DFLOAT
FLAGS_DPBIT = -DFINE_GRAINED_LIBRARIES
INC = -I "$(SRCDIR)/include"
AR_SW = -rcus
LIBPATH = ./libgcc.a
CCUOPTS = 
ASUOPTS = 

all: _muldi3.o _mulhi3.o _mulhisi3.o _mulsidi3.o _mulqihi3.o _negabssi2.o _negdi2.o _lshrdi3.o _ashldi3.o _ashrdi3.o _ashrsi3.o _ashlsi3.o _cmpdi2.o _ucmpdi2.o \
  _clear_cache.o _trampoline.o __main.o _absvsi2.o _absvdi2.o _addvsi3.o _addvdi3.o _subvsi3.o _subvdi3.o _mulvsi3.o _mulvdi3.o _negvsi2.o _negvdi2.o _ctors.o \
  _ffsdi2.o _clz.o _clzdi2.o _ctzdi2.o _popcount_tab.o _popcountdi2.o _paritydi2.o _powisf2.o _powidf2.o _powixf2.o _powitf2.o _mulsc3.o _muldc3.o _mulxc3.o \
  _multc3.o _divsc3.o _divdc3.o _divxc3.o _divtc3.o _bswapsi2.o _bswapdi2.o _clrsbsi2.o _clrsbdi2.o _fixunsdfsi.o _fixunsxfsi.o _fixsfdi.o _fixdfdi.o _fixxfdi.o \
  _fixtfdi.o _fixunssfdi.o _fixunsdfdi.o _fixunsxfdi.o _fixunstfdi.o _floatdisf.o _floatdidf.o _floatdixf.o _floatditf.o _floatundisf.o _floatundidf.o \
  _floatundixf.o _floatunditf.o _eprintf.o _divdi3.o _moddi3.o _udivdi3.o _umoddi3.o _udiv_w_sdiv.o _udivmoddi4.o _pack_sf.o _unpack_sf.o _fpcmp_parts_sf.o \
  _make_sf.o _sf_to_df.o _thenan_sf.o _pack_df.o _unpack_df.o _addsub_df.o _mul_df.o _div_df.o _fpcmp_parts_df.o _compare_df.o _eq_df.o _ne_df.o _gt_df.o \
  _ge_df.o _lt_df.o _le_df.o _unord_df.o _si_to_df.o _df_to_si.o _negate_df.o _make_df.o _df_to_sf.o _thenan_df.o _df_to_usi.o _usi_to_df.o lib2shift.o \
  lshrsi3.o absdi2.o abshi2.o absqi2.o adddi3.o anddi3.o andsi3.o mulsi3.o divmodsi.o divmodhi.o divmodqi.o signbit.o bit-count.o fpbit-sf.o fpmath-sf.o \
  cmpsi2.o enable-execute-stack.o unwind-dw2.o unwind-dw2-fde.o unwind-sjlj.o unwind-c.o emutls.o _cmpmemhi.o _cmpstrhi.o _cmpstrnhi.o _iordi3.o _iorsi3.o _movmemhi.o \
  _movmemqi.o _movstr.o _one_cmpldi2.o _one_cmplsi2.o _rotlrdi3.o _rotlrsi3.o _rotqihi3.o _setmemhi.o _setmemqi.o _shifthi3.o _smaxdi3.o _smaxsi3.o _smindi3.o \
  _sminsi3.o _strlenhi.o _strlenqi.o _subdi3.o _tbljmp.o _udivmodqi.o _umaxdi3.o _umaxsi3.o _umindi3.o _uminsi3.o _umulsi3_hp.o _xordi3.o _xorsi3.o
	@$(AR) $(AR_SW) "$(LIBPATH)" $^


lib: $(patsubst lib,,$(MAKECMDGOALS))
	@$(AR) $(AR_SW) "$(LIBPATH)" *.o

clean:
	-@$(RM) *.o

%.o: %.S
	

_muldi3.o:
	@$(CC) $(ASOPTS) $(FLAGS1) -o $@ -c "$(SRCDIR)/muldi3.S" $(ASUOPTS) $(INC) $(FLAGS2)

_mulhi3.o:
	@$(CC) $(ASOPTS) $(FLAGS1) -o $@ -c "$(SRCDIR)/mulhi3.S" $(ASUOPTS) $(INC) $(FLAGS2)

_mulhisi3.o:
	@$(CC) $(ASOPTS) $(FLAGS1) -o $@ -c "$(SRCDIR)/mulhisi3.S" $(ASUOPTS) $(INC) $(FLAGS2)

_mulsidi3.o:
	@$(CC) $(ASOPTS) $(FLAGS1) -o $@ -c "$(SRCDIR)/mulsidi3.S" $(ASUOPTS) $(INC) $(FLAGS2)

_mulqihi3.o:
	@$(CC) $(ASOPTS) $(FLAGS1) -o $@ -c "$(SRCDIR)/mulqihi3.S" $(ASUOPTS) $(INC) $(FLAGS2)

_negabssi2.o:
	@$(CC) $(ASOPTS) $(FLAGS1) -o $@ -c "$(SRCDIR)/negabssi2.S" $(ASUOPTS) $(INC) $(FLAGS2)

_negdi2.o:
	@$(CC) $(ASOPTS) $(FLAGS1) -o $@ -c "$(SRCDIR)/negdi2.S" $(ASUOPTS) $(INC) $(FLAGS2)

_lshrdi3.o: 
	@$(CC) $(ASOPTS) $(FLAGS1) -o $@ -c "$(SRCDIR)/lshrdi3.S" $(ASUOPTS) $(INC) $(FLAGS2)

_ashldi3.o: 
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_ashldi3 -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) $(INC) $(FLAGS2)

_ashrdi3.o: 
	@$(CC) $(ASOPTS) $(FLAGS1) -o $@ -c "$(SRCDIR)/ashrdi3.S" $(ASUOPTS) $(INC) $(FLAGS2)

_ashrsi3.o: 
	@$(CC) $(ASOPTS) $(FLAGS1) -o $@ -c "$(SRCDIR)/ashrsi3.S" $(ASUOPTS) $(INC) $(FLAGS2)

_ashlsi3.o:
	@$(CC) $(ASOPTS) $(FLAGS1) -o $@ -c "$(SRCDIR)/ashlsi3.S" $(ASUOPTS) $(INC) $(FLAGS2)

_cmpdi2.o: 
	@$(CC) $(ASOPTS) $(FLAGS1) -o $@ -c "$(SRCDIR)/cmpdi2.S" $(ASUOPTS) $(INC) $(FLAGS2)

_ucmpdi2.o: 
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_ucmpdi2 -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) $(INC) $(FLAGS2)

_clear_cache.o: 
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_clear_cache -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) $(INC) $(FLAGS2)

_trampoline.o:
	@$(CC) $(ASOPTS) $(FLAGS1) -o $@ -c "$(SRCDIR)/trampoline.S" $(ASUOPTS) $(INC) $(FLAGS2)

__main.o: 
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL__main -c "$(SRCDIR)/libgcc2.c" -c $(CCUOPTS) $(INC) $(FLAGS2)

_absvsi2.o: 
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_absvsi2 -c "$(SRCDIR)/libgcc2.c" -c $(CCUOPTS) $(INC) $(FLAGS2)

_absvdi2.o: 
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_absvdi2 -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) $(INC) $(FLAGS2)

_addvsi3.o: 
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_addvsi3 -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) $(INC) $(FLAGS2)

_addvdi3.o: 
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_addvdi3 -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) $(INC) $(FLAGS2)

_subvsi3.o: 
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_subvsi3 -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) $(INC) $(FLAGS2)

_subvdi3.o: 
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_subvdi3 -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) $(INC) $(FLAGS2)

_mulvsi3.o: 
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_mulvsi3 -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) $(INC) $(FLAGS2)

_mulvdi3.o: 
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_mulvdi3 -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) $(INC) $(FLAGS2)

_negvsi2.o: 
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_negvsi2 -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) $(INC) $(FLAGS2)

_negvdi2.o: 
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_negvdi2 -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) $(INC) $(FLAGS2)

_ctors.o: 
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_ctors -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) $(INC) $(FLAGS2)

_ffsdi2.o: 
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_ffsdi2 -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) $(INC) $(FLAGS2)

_clz.o: 
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_clz -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) $(INC) $(FLAGS2)

_clzdi2.o: 
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_clzdi2 -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) $(INC) $(FLAGS2)

_ctzdi2.o: 
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_ctzdi2 -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) $(INC) $(FLAGS2)

_popcount_tab.o: 
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_popcount_tab -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) $(INC) $(FLAGS2)

_popcountdi2.o: 
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_popcountdi2 -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) $(INC) $(FLAGS2)

_paritydi2.o: 
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_paritydi2 -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) $(INC) $(FLAGS2)

_powisf2.o: 
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_powisf2 -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) $(INC) $(FLAGS2)

_powidf2.o: 
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_powidf2 -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) $(INC) $(FLAGS2)

_powixf2.o: 
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_powixf2 -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) $(INC) $(FLAGS2)

_powitf2.o: 
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_powitf2 -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) $(INC) $(FLAGS2)

_mulsc3.o: 
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_mulsc3 -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) $(INC) $(FLAGS2)

_muldc3.o: 
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_muldc3 -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) $(INC) $(FLAGS2)

_mulxc3.o: 
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_mulxc3 -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) $(INC) $(FLAGS2)

_multc3.o: 
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_multc3 -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) $(INC) $(FLAGS2)

_divsc3.o: 
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_divsc3 -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) $(INC) $(FLAGS2)

_divdc3.o: 
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_divdc3 -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) $(INC) $(FLAGS2)

_divxc3.o: 
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_divxc3 -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) $(INC) $(FLAGS2)

_divtc3.o: 
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_divtc3 -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) $(INC) $(FLAGS2)

_bswapsi2.o: 
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_bswapsi2 -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) $(INC) $(FLAGS2)

_bswapdi2.o: 
	@$(CC) $(ASOPTS) $(FLAGS1) -o $@ -c "$(SRCDIR)/bswapdi2.S" $(ASUOPTS) $(INC) $(FLAGS2)

_clrsbsi2.o: 
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_clrsbsi2 -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) $(INC) $(FLAGS2)

_clrsbdi2.o: 
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_clrsbdi2 -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) $(INC) $(FLAGS2)

_fixunsdfsi.o: 
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_fixunsdfsi -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) $(INC) $(FLAGS2)

_fixunsxfsi.o: 
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_fixunsxfsi -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) $(INC) $(FLAGS2)

_fixsfdi.o: 
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_fixsfdi -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) $(INC) $(FLAGS2)

_fixdfdi.o: 
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_fixdfdi -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) $(INC) $(FLAGS2)

_fixxfdi.o: 
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_fixxfdi -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) $(INC) $(FLAGS2)

_fixtfdi.o: 
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_fixtfdi -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) $(INC) $(FLAGS2)

_fixunssfdi.o: 
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_fixunssfdi -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) $(INC) $(FLAGS2)

_fixunsdfdi.o: 
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_fixunsdfdi -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) $(INC) $(FLAGS2)

_fixunsxfdi.o: 
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_fixunsxfdi -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) $(INC) $(FLAGS2)

_fixunstfdi.o: 
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_fixunstfdi -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) $(INC) $(FLAGS2)

_floatdisf.o: 
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_floatdisf -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) $(INC) $(FLAGS2)

_floatdidf.o: 
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_floatdidf -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) $(INC) $(FLAGS2)

_floatdixf.o: 
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_floatdixf -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) $(INC) $(FLAGS2)

_floatditf.o: 
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_floatditf -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) $(INC) $(FLAGS2)

_floatundisf.o: 
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_floatundisf -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) $(INC) $(FLAGS2)

_floatundidf.o: 
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_floatundidf -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) $(INC) $(FLAGS2)

_floatundixf.o: 
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_floatundixf -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) $(INC) $(FLAGS2)

_floatunditf.o: 
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_floatunditf -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) $(INC) $(FLAGS2)

_eprintf.o: 
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_eprintf -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) $(INC) $(FLAGS2)

_divdi3.o: 
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_divdi3 -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) $(INC) $(FLAGS2) $(FLAGS_EXEP)

_moddi3.o: 
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_moddi3 -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) $(INC) $(FLAGS2) $(FLAGS_EXEP)

_udivdi3.o: 
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_udivdi3 -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) $(INC) $(FLAGS2) $(FLAGS_EXEP)

_umoddi3.o: 
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_umoddi3 -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) $(INC) $(FLAGS2) $(FLAGS_EXEP)

_udiv_w_sdiv.o: 
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_udiv_w_sdiv -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) $(INC) $(FLAGS2) $(FLAGS_EXEP)

_udivmoddi4.o: 
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_udivmoddi4 -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) $(INC) $(FLAGS2) $(FLAGS_EXEP)

_pack_sf.o: 
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_pack_sf -c "$(SRCDIR)/fp-bit.c" $(CCUOPTS) $(INC) $(FLAGS2) $(FLAGS_FPBIT)

_unpack_sf.o: 
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_unpack_sf -c "$(SRCDIR)/fp-bit.c" $(CCUOPTS) $(INC) $(FLAGS2) $(FLAGS_FPBIT)

_fpcmp_parts_sf.o: 
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_fpcmp_parts_sf -c "$(SRCDIR)/fp-bit.c" $(CCUOPTS) $(INC) $(FLAGS2) $(FLAGS_FPBIT)

_make_sf.o: 
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_make_sf -c "$(SRCDIR)/fp-bit.c" $(CCUOPTS) $(INC) $(FLAGS2) $(FLAGS_FPBIT)

_sf_to_df.o: 
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_sf_to_df -c "$(SRCDIR)/fp-bit.c" $(CCUOPTS) $(INC) $(FLAGS2) $(FLAGS_FPBIT)

_thenan_sf.o: 
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_thenan_sf -c "$(SRCDIR)/fp-bit.c" $(CCUOPTS) $(INC) $(FLAGS2) $(FLAGS_FPBIT)

_pack_df.o: 
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_pack_df -c "$(SRCDIR)/fp-bit.c" $(CCUOPTS) $(INC) $(FLAGS2) $(FLAGS_DPBIT)

_unpack_df.o: 
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_unpack_df -c "$(SRCDIR)/fp-bit.c" $(CCUOPTS) $(INC) $(FLAGS2) $(FLAGS_DPBIT)

_addsub_df.o: 
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_addsub_df -c "$(SRCDIR)/fp-bit.c" $(CCUOPTS) $(INC) $(FLAGS2) $(FLAGS_DPBIT)

_mul_df.o: 
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_mul_df -c "$(SRCDIR)/fp-bit.c" $(CCUOPTS) $(INC) $(FLAGS2) $(FLAGS_DPBIT)

_div_df.o: 
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_div_df -c "$(SRCDIR)/fp-bit.c" $(CCUOPTS) $(INC) $(FLAGS2) $(FLAGS_DPBIT)

_fpcmp_parts_df.o: 
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_fpcmp_parts_df -c "$(SRCDIR)/fp-bit.c" $(CCUOPTS) $(INC) $(FLAGS2) $(FLAGS_DPBIT)

_compare_df.o: 
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_compare_df -c "$(SRCDIR)/fp-bit.c" $(CCUOPTS) $(INC) $(FLAGS2) $(FLAGS_DPBIT)

_eq_df.o: 
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_eq_df -c "$(SRCDIR)/fp-bit.c" $(CCUOPTS) $(INC) $(FLAGS2) $(FLAGS_DPBIT)

_ne_df.o: 
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_ne_df -c "$(SRCDIR)/fp-bit.c" $(CCUOPTS) $(INC) $(FLAGS2) $(FLAGS_DPBIT)

_gt_df.o: 
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_gt_df -c "$(SRCDIR)/fp-bit.c" $(CCUOPTS) $(INC) $(FLAGS2) $(FLAGS_DPBIT)

_ge_df.o: 
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_ge_df -c "$(SRCDIR)/fp-bit.c" $(CCUOPTS) $(INC) $(FLAGS2) $(FLAGS_DPBIT)

_lt_df.o: 
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_lt_df -c "$(SRCDIR)/fp-bit.c" $(CCUOPTS) $(INC) $(FLAGS2) $(FLAGS_DPBIT)

_le_df.o: 
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_le_df -c "$(SRCDIR)/fp-bit.c" $(CCUOPTS) $(INC) $(FLAGS2) $(FLAGS_DPBIT)

_unord_df.o: 
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_unord_df -c "$(SRCDIR)/fp-bit.c" $(CCUOPTS) $(INC) $(FLAGS2) $(FLAGS_DPBIT)

_si_to_df.o: 
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_si_to_df -c "$(SRCDIR)/fp-bit.c" $(CCUOPTS) $(INC) $(FLAGS2) $(FLAGS_DPBIT)

_df_to_si.o: 
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_df_to_si -c "$(SRCDIR)/fp-bit.c" $(CCUOPTS) $(INC) $(FLAGS2) $(FLAGS_DPBIT)

_negate_df.o: 
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_negate_df -c "$(SRCDIR)/fp-bit.c" $(CCUOPTS) $(INC) $(FLAGS2) $(FLAGS_DPBIT)

_make_df.o: 
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_make_df -c "$(SRCDIR)/fp-bit.c" $(CCUOPTS) $(INC) $(FLAGS2) $(FLAGS_DPBIT)

_df_to_sf.o: 
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_df_to_sf -c "$(SRCDIR)/fp-bit.c" $(CCUOPTS) $(INC) $(FLAGS2) $(FLAGS_DPBIT)

_thenan_df.o: 
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_thenan_df -c "$(SRCDIR)/fp-bit.c" $(CCUOPTS) $(INC) $(FLAGS2) $(FLAGS_DPBIT)

_df_to_usi.o: 
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_df_to_usi -c "$(SRCDIR)/fp-bit.c" $(CCUOPTS) $(INC) $(FLAGS2) $(FLAGS_DPBIT)

_usi_to_df.o: 
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_usi_to_df -c "$(SRCDIR)/fp-bit.c" $(CCUOPTS) $(INC) $(FLAGS2) $(FLAGS_DPBIT)

lib2shift.o: 
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -c "$(SRCDIR)/lib2shift.c" $(CCUOPTS) $(INC)

lshrsi3.o: 
	@$(CC) $(ASOPTS) $(FLAGS1) -o $@ -c "$(SRCDIR)/lshrsi3.S" $(ASUOPTS) $(INC)

absdi2.o: 
	@$(CC) $(ASOPTS) $(FLAGS1) -o $@ -c "$(SRCDIR)/absdi2.S" $(ASUOPTS) $(INC)

abshi2.o: 
	@$(CC) $(ASOPTS) $(FLAGS1) -o $@ -c "$(SRCDIR)/abshi2.S" $(ASUOPTS) $(INC)

absqi2.o: 
	@$(CC) $(ASOPTS) $(FLAGS1) -o $@ -c "$(SRCDIR)/absqi2.S" $(ASUOPTS) $(INC)

adddi3.o: 
	@$(CC) $(ASOPTS) $(FLAGS1) -o $@ -c "$(SRCDIR)/adddi3.S" $(ASUOPTS) $(INC)

anddi3.o: 
	@$(CC) $(ASOPTS) $(FLAGS1) -o $@ -c "$(SRCDIR)/anddi3.S" $(ASUOPTS) $(INC)

andsi3.o: 
	@$(CC) $(ASOPTS) $(FLAGS1) -o $@ -c "$(SRCDIR)/andsi3.S" $(ASUOPTS) $(INC)

mulsi3.o: 
	@$(CC) $(ASOPTS) $(FLAGS1) -o $@ -c "$(SRCDIR)/mulsi3.S" $(ASUOPTS) $(INC)

divmodsi.o: 
	@$(CC) $(ASOPTS) $(FLAGS1) -o $@ -c "$(SRCDIR)/divmodsi.S" $(ASUOPTS) $(INC)

divmodhi.o: 
	@$(CC) $(ASOPTS) $(FLAGS1) -o $@ -c "$(SRCDIR)/divmodhi.S" $(ASUOPTS) $(INC)

divmodqi.o: 
	@$(CC) $(ASOPTS) $(FLAGS1) -o $@ -c "$(SRCDIR)/divmodqi.S" $(ASUOPTS) $(INC)

signbit.o: 
	@$(CC) $(ASOPTS) $(FLAGS1) -o $@ -c "$(SRCDIR)/signbit.S" $(ASUOPTS) $(INC)

bit-count.o: 
	@$(CC) $(ASOPTS) $(FLAGS1) -o $@ -c "$(SRCDIR)/bit-count.S" $(ASUOPTS) $(INC)

fpbit-sf.o: 
	@$(CC) $(ASOPTS) $(FLAGS1) -o $@ -c "$(SRCDIR)/fpbit-sf.S" $(ASUOPTS) $(INC)

fpmath-sf.o: 
	@$(CC) $(ASOPTS) $(FLAGS1) -o $@ -c "$(SRCDIR)/fpmath-sf.S" $(ASUOPTS) $(INC)

cmpsi2.o: 
	@$(CC) $(ASOPTS) $(FLAGS1) -o $@ -c "$(SRCDIR)/cmpsi2.S" $(ASUOPTS) $(INC)

enable-execute-stack.o: 
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -c "$(SRCDIR)/enable-execute-stack.c" $(CCUOPTS) $(INC) $(FLAGS2)

unwind-dw2.o: 
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -c "$(SRCDIR)/unwind-dw2.c" $(CCUOPTS) $(INC) $(FLAGS2) $(FLAGS_EXEP2)

unwind-dw2-fde.o: 
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -c "$(SRCDIR)/unwind-dw2-fde.c" $(CCUOPTS) $(INC) $(FLAGS2) $(FLAGS_EXEP2)

unwind-sjlj.o: 
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -c "$(SRCDIR)/unwind-sjlj.c" $(CCUOPTS) $(INC) $(FLAGS2) $(FLAGS_EXEP2)

unwind-c.o: 
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -c "$(SRCDIR)/unwind-c.c" $(CCUOPTS) $(INC) $(FLAGS2) $(FLAGS_EXEP2)

emutls.o: 
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -c "$(SRCDIR)/emutls.c" $(CCUOPTS) $(INC) $(FLAGS2) $(FLAGS_EXEP2)

_cmpmemhi.o:
	@$(CC) $(ASOPTS) $(FLAGS1) -o $@ -c "$(SRCDIR)/cmpmemhi.S" $(ASUOPTS) $(INC)

_cmpstrhi.o:
	@$(CC) $(ASOPTS) $(FLAGS1) -o $@ -c "$(SRCDIR)/cmpstrhi.S" $(ASUOPTS) $(INC)

_cmpstrnhi.o:
	@$(CC) $(ASOPTS) $(FLAGS1) -o $@ -c "$(SRCDIR)/cmpstrnhi.S" $(ASUOPTS) $(INC)

_iordi3.o:
	@$(CC) $(ASOPTS) $(FLAGS1) -o $@ -c "$(SRCDIR)/iordi3.S" $(ASUOPTS) $(INC)

_iorsi3.o:
	@$(CC) $(ASOPTS) $(FLAGS1) -o $@ -c "$(SRCDIR)/iorsi3.S" $(ASUOPTS) $(INC)

_movmemhi.o:
	@$(CC) $(ASOPTS) $(FLAGS1) -o $@ -c "$(SRCDIR)/movmemhi.S" $(ASUOPTS) $(INC)

_movmemqi.o:
	@$(CC) $(ASOPTS) $(FLAGS1) -o $@ -c "$(SRCDIR)/movmemqi.S" $(ASUOPTS) $(INC)

_movstr.o:
	@$(CC) $(ASOPTS) $(FLAGS1) -o $@ -c "$(SRCDIR)/movstr.S" $(ASUOPTS) $(INC)

_one_cmpldi2.o:
	@$(CC) $(ASOPTS) $(FLAGS1) -o $@ -c "$(SRCDIR)/one_cmpldi2.S" $(ASUOPTS) $(INC)

_one_cmplsi2.o:
	@$(CC) $(ASOPTS) $(FLAGS1) -o $@ -c "$(SRCDIR)/one_cmplsi2.S" $(ASUOPTS) $(INC)

_rotlrdi3.o:
	@$(CC) $(ASOPTS) $(FLAGS1) -o $@ -c "$(SRCDIR)/rotlrdi3.S" $(ASUOPTS) $(INC)

_rotlrsi3.o:
	@$(CC) $(ASOPTS) $(FLAGS1) -o $@ -c "$(SRCDIR)/rotlrsi3.S" $(ASUOPTS) $(INC)

_rotqihi3.o:
	@$(CC) $(ASOPTS) $(FLAGS1) -o $@ -c "$(SRCDIR)/rotqihi3.S" $(ASUOPTS) $(INC)

_setmemhi.o:
	@$(CC) $(ASOPTS) $(FLAGS1) -o $@ -c "$(SRCDIR)/setmemhi.S" $(ASUOPTS) $(INC)

_setmemqi.o:
	@$(CC) $(ASOPTS) $(FLAGS1) -o $@ -c "$(SRCDIR)/setmemqi.S" $(ASUOPTS) $(INC)

_shifthi3.o:
	@$(CC) $(ASOPTS) $(FLAGS1) -o $@ -c "$(SRCDIR)/shifthi3.S" $(ASUOPTS) $(INC)

_smaxdi3.o:
	@$(CC) $(ASOPTS) $(FLAGS1) -o $@ -c "$(SRCDIR)/smaxdi3.S" $(ASUOPTS) $(INC)

_smaxsi3.o:
	@$(CC) $(ASOPTS) $(FLAGS1) -o $@ -c "$(SRCDIR)/smaxsi3.S" $(ASUOPTS) $(INC)

_smindi3.o:
	@$(CC) $(ASOPTS) $(FLAGS1) -o $@ -c "$(SRCDIR)/smindi3.S" $(ASUOPTS) $(INC)

_sminsi3.o:
	@$(CC) $(ASOPTS) $(FLAGS1) -o $@ -c "$(SRCDIR)/sminsi3.S" $(ASUOPTS) $(INC)

_strlenhi.o:
	@$(CC) $(ASOPTS) $(FLAGS1) -o $@ -c "$(SRCDIR)/strlenhi.S" $(ASUOPTS) $(INC)

_strlenqi.o:
	@$(CC) $(ASOPTS) $(FLAGS1) -o $@ -c "$(SRCDIR)/strlenqi.S" $(ASUOPTS) $(INC)

_subdi3.o:
	@$(CC) $(ASOPTS) $(FLAGS1) -o $@ -c "$(SRCDIR)/subdi3.S" $(ASUOPTS) $(INC)

_tbljmp.o:
	@$(CC) $(ASOPTS) $(FLAGS1) -o $@ -c "$(SRCDIR)/tbljmp.S" $(ASUOPTS) $(INC)

_udivmodqi.o:
	@$(CC) $(ASOPTS) $(FLAGS1) -o $@ -c "$(SRCDIR)/udivmodqi.S" $(ASUOPTS) $(INC)

_umaxdi3.o:
	@$(CC) $(ASOPTS) $(FLAGS1) -o $@ -c "$(SRCDIR)/umaxdi3.S" $(ASUOPTS) $(INC)

_umaxsi3.o:
	@$(CC) $(ASOPTS) $(FLAGS1) -o $@ -c "$(SRCDIR)/umaxsi3.S" $(ASUOPTS) $(INC)

_umindi3.o:
	@$(CC) $(ASOPTS) $(FLAGS1) -o $@ -c "$(SRCDIR)/umindi3.S" $(ASUOPTS) $(INC)

_uminsi3.o:
	@$(CC) $(ASOPTS) $(FLAGS1) -o $@ -c "$(SRCDIR)/uminsi3.S" $(ASUOPTS) $(INC)

_umulsi3_hp.o:
	@$(CC) $(ASOPTS) $(FLAGS1) -o $@ -c "$(SRCDIR)/umulsi3_hp.S" $(ASUOPTS) $(INC)

_xordi3.o:
	@$(CC) $(ASOPTS) $(FLAGS1) -o $@ -c "$(SRCDIR)/xordi3.S" $(ASUOPTS) $(INC)

_xorsi3.o:
	@$(CC) $(ASOPTS) $(FLAGS1) -o $@ -c "$(SRCDIR)/xorsi3.S" $(ASUOPTS) $(INC)
