/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xalan.internal.xsltc.cmdline;

import com.sun.org.apache.xalan.internal.utils.ObjectFactory;
import com.sun.org.apache.xalan.internal.xsltc.DOM;
import com.sun.org.apache.xalan.internal.xsltc.DOMEnhancedForDTM;
import com.sun.org.apache.xalan.internal.xsltc.StripFilter;
import com.sun.org.apache.xalan.internal.xsltc.TransletException;
import com.sun.org.apache.xalan.internal.xsltc.compiler.util.ErrorMsg;
import com.sun.org.apache.xalan.internal.xsltc.dom.DOMWSFilter;
import com.sun.org.apache.xalan.internal.xsltc.dom.XSLTCDTMManager;
import com.sun.org.apache.xalan.internal.xsltc.runtime.AbstractTranslet;
import com.sun.org.apache.xalan.internal.xsltc.runtime.Parameter;
import com.sun.org.apache.xalan.internal.xsltc.runtime.output.TransletOutputHandlerFactory;
import com.sun.org.apache.xml.internal.serializer.SerializationHandler;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.util.Vector;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.sax.SAXSource;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public final class Transform {
    private SerializationHandler _handler;
    private String _fileName;
    private String _className;
    private String _jarFileSrc;
    private boolean _isJarFileSpecified = false;
    private Vector _params = null;
    private boolean _uri;
    private boolean _debug;
    private int _iterations;

    public Transform(String string, String string2, boolean bl, boolean bl2, int n) {
        this._fileName = string2;
        this._className = string;
        this._uri = bl;
        this._debug = bl2;
        this._iterations = n;
    }

    public String getFileName() {
        return this._fileName;
    }

    public String getClassName() {
        return this._className;
    }

    public void setParameters(Vector vector) {
        this._params = vector;
    }

    private void setJarFileInputSrc(boolean bl, String string) {
        this._isJarFileSpecified = bl;
        this._jarFileSrc = string;
    }

    private void doTransform() {
        try {
            Class<?> clazz = ObjectFactory.findProviderClass(this._className, true);
            AbstractTranslet abstractTranslet = (AbstractTranslet)clazz.newInstance();
            abstractTranslet.postInitialization();
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            try {
                sAXParserFactory.setFeature("http://xml.org/sax/features/namespaces", true);
            }
            catch (Exception exception) {
                sAXParserFactory.setNamespaceAware(true);
            }
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            XMLReader xMLReader = sAXParser.getXMLReader();
            XSLTCDTMManager xSLTCDTMManager = XSLTCDTMManager.createNewDTMManagerInstance();
            DOMWSFilter dOMWSFilter = abstractTranslet != null && abstractTranslet instanceof StripFilter ? new DOMWSFilter(abstractTranslet) : null;
            DOMEnhancedForDTM dOMEnhancedForDTM = (DOMEnhancedForDTM)((Object)xSLTCDTMManager.getDTM(new SAXSource(xMLReader, new InputSource(this._fileName)), false, dOMWSFilter, true, false, abstractTranslet.hasIdCall()));
            dOMEnhancedForDTM.setDocumentURI(this._fileName);
            abstractTranslet.prepassDocument(dOMEnhancedForDTM);
            int n = this._params.size();
            for (int i = 0; i < n; ++i) {
                Parameter parameter = (Parameter)this._params.elementAt(i);
                abstractTranslet.addParameter(parameter._name, parameter._value);
            }
            TransletOutputHandlerFactory transletOutputHandlerFactory = TransletOutputHandlerFactory.newInstance();
            transletOutputHandlerFactory.setOutputType(0);
            transletOutputHandlerFactory.setEncoding(abstractTranslet._encoding);
            transletOutputHandlerFactory.setOutputMethod(abstractTranslet._method);
            if (this._iterations == -1) {
                abstractTranslet.transform((DOM)dOMEnhancedForDTM, transletOutputHandlerFactory.getSerializationHandler());
            } else if (this._iterations > 0) {
                long l = System.currentTimeMillis();
                for (int i = 0; i < this._iterations; ++i) {
                    abstractTranslet.transform((DOM)dOMEnhancedForDTM, transletOutputHandlerFactory.getSerializationHandler());
                }
                l = System.currentTimeMillis() - l;
                System.err.println("\n<!--");
                System.err.println("  transform  = " + (double)l / (double)this._iterations + " ms");
                System.err.println("  throughput = " + 1000.0 / ((double)l / (double)this._iterations) + " tps");
                System.err.println("-->");
            }
        }
        catch (TransletException transletException) {
            if (this._debug) {
                transletException.printStackTrace();
            }
            System.err.println(new ErrorMsg("RUNTIME_ERROR_KEY") + transletException.getMessage());
        }
        catch (RuntimeException runtimeException) {
            if (this._debug) {
                runtimeException.printStackTrace();
            }
            System.err.println(new ErrorMsg("RUNTIME_ERROR_KEY") + runtimeException.getMessage());
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (this._debug) {
                fileNotFoundException.printStackTrace();
            }
            ErrorMsg errorMsg = new ErrorMsg("FILE_NOT_FOUND_ERR", this._fileName);
            System.err.println(new ErrorMsg("RUNTIME_ERROR_KEY") + errorMsg.toString());
        }
        catch (MalformedURLException malformedURLException) {
            if (this._debug) {
                malformedURLException.printStackTrace();
            }
            ErrorMsg errorMsg = new ErrorMsg("INVALID_URI_ERR", this._fileName);
            System.err.println(new ErrorMsg("RUNTIME_ERROR_KEY") + errorMsg.toString());
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (this._debug) {
                classNotFoundException.printStackTrace();
            }
            ErrorMsg errorMsg = new ErrorMsg("CLASS_NOT_FOUND_ERR", this._className);
            System.err.println(new ErrorMsg("RUNTIME_ERROR_KEY") + errorMsg.toString());
        }
        catch (UnknownHostException unknownHostException) {
            if (this._debug) {
                unknownHostException.printStackTrace();
            }
            ErrorMsg errorMsg = new ErrorMsg("INVALID_URI_ERR", this._fileName);
            System.err.println(new ErrorMsg("RUNTIME_ERROR_KEY") + errorMsg.toString());
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException.getException();
            if (this._debug) {
                if (exception != null) {
                    exception.printStackTrace();
                }
                sAXException.printStackTrace();
            }
            System.err.print(new ErrorMsg("RUNTIME_ERROR_KEY"));
            if (exception != null) {
                System.err.println(exception.getMessage());
            } else {
                System.err.println(sAXException.getMessage());
            }
        }
        catch (Exception exception) {
            if (this._debug) {
                exception.printStackTrace();
            }
            System.err.println(new ErrorMsg("RUNTIME_ERROR_KEY") + exception.getMessage());
        }
    }

    public static void printUsage() {
        System.err.println(new ErrorMsg("TRANSFORM_USAGE_STR"));
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length > 0) {
                int n;
                int n2 = -1;
                boolean bl = false;
                boolean bl2 = false;
                boolean bl3 = false;
                String string = null;
                for (n = 0; n < stringArray.length && stringArray[n].charAt(0) == '-'; ++n) {
                    if (stringArray[n].equals("-u")) {
                        bl = true;
                        continue;
                    }
                    if (stringArray[n].equals("-x")) {
                        bl2 = true;
                        continue;
                    }
                    if (stringArray[n].equals("-j")) {
                        bl3 = true;
                        string = stringArray[++n];
                        continue;
                    }
                    if (stringArray[n].equals("-n")) {
                        try {
                            n2 = Integer.parseInt(stringArray[++n]);
                        }
                        catch (NumberFormatException numberFormatException) {}
                        continue;
                    }
                    Transform.printUsage();
                }
                if (stringArray.length - n < 2) {
                    Transform.printUsage();
                }
                Transform transform = new Transform(stringArray[n + 1], stringArray[n], bl, bl2, n2);
                transform.setJarFileInputSrc(bl3, string);
                Vector<Parameter> vector = new Vector<Parameter>();
                n += 2;
                while (n < stringArray.length) {
                    int n3 = stringArray[n].indexOf(61);
                    if (n3 > 0) {
                        String string2 = stringArray[n].substring(0, n3);
                        String string3 = stringArray[n].substring(n3 + 1);
                        vector.addElement(new Parameter(string2, string3));
                    } else {
                        Transform.printUsage();
                    }
                    ++n;
                }
                if (n == stringArray.length) {
                    transform.setParameters(vector);
                    transform.doTransform();
                }
            } else {
                Transform.printUsage();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

