/*
 * Decompiled with CFR 0.152.
 */
package com.sun.activation.registries;

import com.sun.activation.registries.LogSupport;
import com.sun.activation.registries.MailcapParseException;
import com.sun.activation.registries.MailcapTokenizer;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class MailcapFile {
    private Map type_hash = new HashMap();
    private Map fallback_hash = new HashMap();
    private Map native_commands = new HashMap();
    private static boolean addReverse = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MailcapFile(String string) throws IOException {
        if (LogSupport.isLoggable()) {
            LogSupport.log("new MailcapFile: file " + string);
        }
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(string);
            this.parse(new BufferedReader(fileReader));
        }
        finally {
            if (fileReader != null) {
                try {
                    fileReader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public MailcapFile(InputStream inputStream) throws IOException {
        if (LogSupport.isLoggable()) {
            LogSupport.log("new MailcapFile: InputStream");
        }
        this.parse(new BufferedReader(new InputStreamReader(inputStream, "iso-8859-1")));
    }

    public MailcapFile() {
        if (LogSupport.isLoggable()) {
            LogSupport.log("new MailcapFile: default");
        }
    }

    public Map getMailcapList(String string) {
        String string2;
        Map map = null;
        Map map2 = null;
        map = (Map)this.type_hash.get(string);
        int n = string.indexOf(47);
        String string3 = string.substring(n + 1);
        if (!string3.equals("*") && (map2 = (Map)this.type_hash.get(string2 = string.substring(0, n + 1) + "*")) != null) {
            map = map != null ? this.mergeResults(map, map2) : map2;
        }
        return map;
    }

    public Map getMailcapFallbackList(String string) {
        String string2;
        Map map = null;
        Map map2 = null;
        map = (Map)this.fallback_hash.get(string);
        int n = string.indexOf(47);
        String string3 = string.substring(n + 1);
        if (!string3.equals("*") && (map2 = (Map)this.fallback_hash.get(string2 = string.substring(0, n + 1) + "*")) != null) {
            map = map != null ? this.mergeResults(map, map2) : map2;
        }
        return map;
    }

    public String[] getMimeTypes() {
        HashSet hashSet = new HashSet(this.type_hash.keySet());
        hashSet.addAll(this.fallback_hash.keySet());
        hashSet.addAll(this.native_commands.keySet());
        String[] stringArray = new String[hashSet.size()];
        stringArray = hashSet.toArray(stringArray);
        return stringArray;
    }

    public String[] getNativeCommands(String string) {
        String[] stringArray = null;
        List list = (List)this.native_commands.get(string.toLowerCase(Locale.ENGLISH));
        if (list != null) {
            stringArray = new String[list.size()];
            stringArray = list.toArray(stringArray);
        }
        return stringArray;
    }

    private Map mergeResults(Map map, Map map2) {
        Iterator iterator = map2.keySet().iterator();
        HashMap hashMap = new HashMap(map);
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            ArrayList arrayList = (ArrayList)hashMap.get(string);
            if (arrayList == null) {
                hashMap.put(string, map2.get(string));
                continue;
            }
            List list = (List)map2.get(string);
            arrayList = new ArrayList(arrayList);
            arrayList.addAll(list);
            hashMap.put(string, arrayList);
        }
        return hashMap;
    }

    public void appendToMailcap(String string) {
        if (LogSupport.isLoggable()) {
            LogSupport.log("appendToMailcap: " + string);
        }
        try {
            this.parse(new StringReader(string));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void parse(Reader reader) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(reader);
        String string = null;
        String string2 = null;
        while ((string = bufferedReader.readLine()) != null) {
            string = string.trim();
            try {
                if (string.charAt(0) == '#') continue;
                if (string.charAt(string.length() - 1) == '\\') {
                    if (string2 != null) {
                        string2 = string2 + string.substring(0, string.length() - 1);
                        continue;
                    }
                    string2 = string.substring(0, string.length() - 1);
                    continue;
                }
                if (string2 != null) {
                    string2 = string2 + string;
                    try {
                        this.parseLine(string2);
                    }
                    catch (MailcapParseException mailcapParseException) {
                        // empty catch block
                    }
                    string2 = null;
                    continue;
                }
                try {
                    this.parseLine(string);
                }
                catch (MailcapParseException mailcapParseException) {
                }
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {}
        }
    }

    protected void parseLine(String string) throws MailcapParseException, IOException {
        int n;
        MailcapTokenizer mailcapTokenizer = new MailcapTokenizer(string);
        mailcapTokenizer.setIsAutoquoting(false);
        if (LogSupport.isLoggable()) {
            LogSupport.log("parse: " + string);
        }
        if ((n = mailcapTokenizer.nextToken()) != 2) {
            MailcapFile.reportParseError(2, n, mailcapTokenizer.getCurrentTokenValue());
        }
        String string2 = mailcapTokenizer.getCurrentTokenValue().toLowerCase(Locale.ENGLISH);
        String string3 = "*";
        n = mailcapTokenizer.nextToken();
        if (n != 47 && n != 59) {
            MailcapFile.reportParseError(47, 59, n, mailcapTokenizer.getCurrentTokenValue());
        }
        if (n == 47) {
            n = mailcapTokenizer.nextToken();
            if (n != 2) {
                MailcapFile.reportParseError(2, n, mailcapTokenizer.getCurrentTokenValue());
            }
            string3 = mailcapTokenizer.getCurrentTokenValue().toLowerCase(Locale.ENGLISH);
            n = mailcapTokenizer.nextToken();
        }
        String string4 = string2 + "/" + string3;
        if (LogSupport.isLoggable()) {
            LogSupport.log("  Type: " + string4);
        }
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        if (n != 59) {
            MailcapFile.reportParseError(59, n, mailcapTokenizer.getCurrentTokenValue());
        }
        mailcapTokenizer.setIsAutoquoting(true);
        n = mailcapTokenizer.nextToken();
        mailcapTokenizer.setIsAutoquoting(false);
        if (n != 2 && n != 59) {
            MailcapFile.reportParseError(2, 59, n, mailcapTokenizer.getCurrentTokenValue());
        }
        if (n == 2) {
            ArrayList<String> arrayList = (ArrayList<String>)this.native_commands.get(string4);
            if (arrayList == null) {
                arrayList = new ArrayList<String>();
                arrayList.add(string);
                this.native_commands.put(string4, arrayList);
            } else {
                arrayList.add(string);
            }
        }
        if (n != 59) {
            n = mailcapTokenizer.nextToken();
        }
        if (n == 59) {
            Object object;
            Object object2;
            boolean bl = false;
            do {
                if ((n = mailcapTokenizer.nextToken()) != 2) {
                    MailcapFile.reportParseError(2, n, mailcapTokenizer.getCurrentTokenValue());
                }
                object2 = mailcapTokenizer.getCurrentTokenValue().toLowerCase(Locale.ENGLISH);
                n = mailcapTokenizer.nextToken();
                if (n != 61 && n != 59 && n != 5) {
                    MailcapFile.reportParseError(61, 59, 5, n, mailcapTokenizer.getCurrentTokenValue());
                }
                if (n != 61) continue;
                mailcapTokenizer.setIsAutoquoting(true);
                n = mailcapTokenizer.nextToken();
                mailcapTokenizer.setIsAutoquoting(false);
                if (n != 2) {
                    MailcapFile.reportParseError(2, n, mailcapTokenizer.getCurrentTokenValue());
                }
                object = mailcapTokenizer.getCurrentTokenValue();
                if (((String)object2).startsWith("x-java-")) {
                    String string5 = ((String)object2).substring(7);
                    if (string5.equals("fallback-entry") && ((String)object).equalsIgnoreCase("true")) {
                        bl = true;
                    } else {
                        Object object3;
                        if (LogSupport.isLoggable()) {
                            LogSupport.log("    Command: " + string5 + ", Class: " + (String)object);
                        }
                        if ((object3 = (List)linkedHashMap.get(string5)) == null) {
                            object3 = new ArrayList<Object>();
                            linkedHashMap.put(string5, (ArrayList<Object>)object3);
                        }
                        if (addReverse) {
                            object3.add(0, object);
                        } else {
                            object3.add(object);
                        }
                    }
                }
                n = mailcapTokenizer.nextToken();
            } while (n == 59);
            object2 = bl ? this.fallback_hash : this.type_hash;
            object = (Map)object2.get(string4);
            if (object == null) {
                object2.put(string4, linkedHashMap);
            } else {
                List list;
                if (LogSupport.isLoggable()) {
                    LogSupport.log("Merging commands for type " + string4);
                }
                for (Object object3 : object.keySet()) {
                    list = (List)object.get(object3);
                    List list2 = (List)linkedHashMap.get(object3);
                    if (list2 == null) continue;
                    for (String string6 : list2) {
                        if (list.contains(string6)) continue;
                        if (addReverse) {
                            list.add(0, string6);
                            continue;
                        }
                        list.add(string6);
                    }
                }
                for (Object object3 : linkedHashMap.keySet()) {
                    if (object.containsKey(object3)) continue;
                    list = (List)linkedHashMap.get(object3);
                    object.put(object3, list);
                }
            }
        } else if (n != 5) {
            MailcapFile.reportParseError(5, 59, n, mailcapTokenizer.getCurrentTokenValue());
        }
    }

    protected static void reportParseError(int n, int n2, String string) throws MailcapParseException {
        throw new MailcapParseException("Encountered a " + MailcapTokenizer.nameForToken(n2) + " token (" + string + ") while expecting a " + MailcapTokenizer.nameForToken(n) + " token.");
    }

    protected static void reportParseError(int n, int n2, int n3, String string) throws MailcapParseException {
        throw new MailcapParseException("Encountered a " + MailcapTokenizer.nameForToken(n3) + " token (" + string + ") while expecting a " + MailcapTokenizer.nameForToken(n) + " or a " + MailcapTokenizer.nameForToken(n2) + " token.");
    }

    protected static void reportParseError(int n, int n2, int n3, int n4, String string) throws MailcapParseException {
        if (LogSupport.isLoggable()) {
            LogSupport.log("PARSE ERROR: Encountered a " + MailcapTokenizer.nameForToken(n4) + " token (" + string + ") while expecting a " + MailcapTokenizer.nameForToken(n) + ", a " + MailcapTokenizer.nameForToken(n2) + ", or a " + MailcapTokenizer.nameForToken(n3) + " token.");
        }
        throw new MailcapParseException("Encountered a " + MailcapTokenizer.nameForToken(n4) + " token (" + string + ") while expecting a " + MailcapTokenizer.nameForToken(n) + ", a " + MailcapTokenizer.nameForToken(n2) + ", or a " + MailcapTokenizer.nameForToken(n3) + " token.");
    }

    static {
        try {
            addReverse = Boolean.getBoolean("javax.activation.addreverse");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

