/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.motif;

import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.LookAndFeel;
import javax.swing.MenuSelectionManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicCheckBoxMenuItemUI;

public class MotifCheckBoxMenuItemUI
extends BasicCheckBoxMenuItemUI {
    protected ChangeListener changeListener;

    public static ComponentUI createUI(JComponent jComponent) {
        return new MotifCheckBoxMenuItemUI();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.changeListener = this.createChangeListener(this.menuItem);
        this.menuItem.addChangeListener(this.changeListener);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.menuItem.removeChangeListener(this.changeListener);
    }

    protected ChangeListener createChangeListener(JComponent jComponent) {
        return new ChangeHandler();
    }

    @Override
    protected MouseInputListener createMouseInputListener(JComponent jComponent) {
        return new MouseInputHandler();
    }

    protected class ChangeHandler
    implements ChangeListener {
        protected ChangeHandler() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            JMenuItem jMenuItem = (JMenuItem)changeEvent.getSource();
            LookAndFeel.installProperty(jMenuItem, "borderPainted", jMenuItem.isArmed());
        }
    }

    protected class MouseInputHandler
    implements MouseInputListener {
        protected MouseInputHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            menuSelectionManager.setSelectedPath(MotifCheckBoxMenuItemUI.this.getPath());
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            JMenuItem jMenuItem = (JMenuItem)mouseEvent.getComponent();
            Point point = mouseEvent.getPoint();
            if (point.x >= 0 && point.x < jMenuItem.getWidth() && point.y >= 0 && point.y < jMenuItem.getHeight()) {
                menuSelectionManager.clearSelectedPath();
                jMenuItem.doClick(0);
            } else {
                menuSelectionManager.processMouseEvent(mouseEvent);
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            MenuSelectionManager.defaultManager().processMouseEvent(mouseEvent);
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }
    }
}

