/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.org.jvnet.staxex;

import com.sun.xml.internal.org.jvnet.staxex.Base64Encoder;
import com.sun.xml.internal.org.jvnet.staxex.Base64EncoderStream;
import com.sun.xml.internal.org.jvnet.staxex.ByteArrayOutputStreamEx;
import com.sun.xml.internal.org.jvnet.staxex.StreamingDataHandler;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class Base64Data
implements CharSequence,
Cloneable {
    private DataHandler dataHandler;
    private byte[] data;
    private int dataLen;
    private boolean dataCloneByRef;
    private String mimeType;
    private static final Logger logger = Logger.getLogger(Base64Data.class.getName());
    private static final int CHUNK_SIZE;

    public Base64Data() {
    }

    public Base64Data(Base64Data base64Data) {
        base64Data.get();
        if (base64Data.dataCloneByRef) {
            this.data = base64Data.data;
        } else {
            this.data = new byte[base64Data.dataLen];
            System.arraycopy(base64Data.data, 0, this.data, 0, base64Data.dataLen);
        }
        this.dataCloneByRef = true;
        this.dataLen = base64Data.dataLen;
        this.dataHandler = null;
        this.mimeType = base64Data.mimeType;
    }

    public void set(byte[] byArray, int n, String string, boolean bl) {
        this.data = byArray;
        this.dataLen = n;
        this.dataCloneByRef = bl;
        this.dataHandler = null;
        this.mimeType = string;
    }

    public void set(byte[] byArray, int n, String string) {
        this.set(byArray, n, string, false);
    }

    public void set(byte[] byArray, String string) {
        this.set(byArray, byArray.length, string, false);
    }

    public void set(DataHandler dataHandler) {
        assert (dataHandler != null);
        this.dataHandler = dataHandler;
        this.data = null;
    }

    public DataHandler getDataHandler() {
        if (this.dataHandler == null) {
            this.dataHandler = new Base64StreamingDataHandler(new Base64DataSource());
        } else if (!(this.dataHandler instanceof StreamingDataHandler)) {
            this.dataHandler = new FilterDataHandler(this.dataHandler);
        }
        return this.dataHandler;
    }

    public byte[] getExact() {
        this.get();
        if (this.dataLen != this.data.length) {
            byte[] byArray = new byte[this.dataLen];
            System.arraycopy(this.data, 0, byArray, 0, this.dataLen);
            this.data = byArray;
        }
        return this.data;
    }

    public InputStream getInputStream() throws IOException {
        if (this.dataHandler != null) {
            return this.dataHandler.getInputStream();
        }
        return new ByteArrayInputStream(this.data, 0, this.dataLen);
    }

    public boolean hasData() {
        return this.data != null;
    }

    public byte[] get() {
        if (this.data == null) {
            try {
                ByteArrayOutputStreamEx byteArrayOutputStreamEx = new ByteArrayOutputStreamEx(1024);
                InputStream inputStream = this.dataHandler.getDataSource().getInputStream();
                byteArrayOutputStreamEx.readFrom(inputStream);
                inputStream.close();
                this.data = byteArrayOutputStreamEx.getBuffer();
                this.dataLen = byteArrayOutputStreamEx.size();
                this.dataCloneByRef = true;
            }
            catch (IOException iOException) {
                this.dataLen = 0;
            }
        }
        return this.data;
    }

    public int getDataLen() {
        this.get();
        return this.dataLen;
    }

    public String getMimeType() {
        if (this.mimeType == null) {
            return "application/octet-stream";
        }
        return this.mimeType;
    }

    @Override
    public int length() {
        this.get();
        return (this.dataLen + 2) / 3 * 4;
    }

    @Override
    public char charAt(int n) {
        int n2 = n % 4;
        int n3 = n / 4 * 3;
        switch (n2) {
            case 0: {
                return Base64Encoder.encode(this.data[n3] >> 2);
            }
            case 1: {
                byte by = n3 + 1 < this.dataLen ? this.data[n3 + 1] : (byte)0;
                return Base64Encoder.encode((this.data[n3] & 3) << 4 | by >> 4 & 0xF);
            }
            case 2: {
                if (n3 + 1 < this.dataLen) {
                    byte by = this.data[n3 + 1];
                    byte by2 = n3 + 2 < this.dataLen ? this.data[n3 + 2] : (byte)0;
                    return Base64Encoder.encode((by & 0xF) << 2 | by2 >> 6 & 3);
                }
                return '=';
            }
            case 3: {
                if (n3 + 2 < this.dataLen) {
                    return Base64Encoder.encode(this.data[n3 + 2] & 0x3F);
                }
                return '=';
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public CharSequence subSequence(int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        this.get();
        for (int i = n; i < n2; ++i) {
            stringBuilder.append(this.charAt(i));
        }
        return stringBuilder;
    }

    @Override
    public String toString() {
        this.get();
        return Base64Encoder.print(this.data, 0, this.dataLen);
    }

    public void writeTo(char[] cArray, int n) {
        this.get();
        Base64Encoder.print(this.data, 0, this.dataLen, cArray, n);
    }

    public void writeTo(XMLStreamWriter xMLStreamWriter) throws IOException, XMLStreamException {
        if (this.data == null) {
            try {
                int n;
                InputStream inputStream = this.dataHandler.getDataSource().getInputStream();
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                Base64EncoderStream base64EncoderStream = new Base64EncoderStream(xMLStreamWriter, byteArrayOutputStream);
                byte[] byArray = new byte[CHUNK_SIZE];
                while ((n = inputStream.read(byArray)) != -1) {
                    base64EncoderStream.write(byArray, 0, n);
                }
                byteArrayOutputStream.close();
                base64EncoderStream.close();
            }
            catch (IOException iOException) {
                this.dataLen = 0;
                throw iOException;
            }
        } else {
            String string = Base64Encoder.print(this.data, 0, this.dataLen);
            xMLStreamWriter.writeCharacters(string);
        }
    }

    public Base64Data clone() {
        try {
            Base64Data base64Data = (Base64Data)super.clone();
            base64Data.get();
            if (base64Data.dataCloneByRef) {
                this.data = base64Data.data;
            } else {
                this.data = new byte[base64Data.dataLen];
                System.arraycopy(base64Data.data, 0, this.data, 0, base64Data.dataLen);
            }
            this.dataCloneByRef = true;
            this.dataLen = base64Data.dataLen;
            this.dataHandler = null;
            this.mimeType = base64Data.mimeType;
            return base64Data;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            Logger.getLogger(Base64Data.class.getName()).log(Level.SEVERE, null, cloneNotSupportedException);
            return null;
        }
    }

    static String getProperty(final String string) {
        if (System.getSecurityManager() == null) {
            return System.getProperty(string);
        }
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(string);
            }
        });
    }

    static {
        int n = 1024;
        try {
            String string = Base64Data.getProperty("com.sun.xml.internal.org.jvnet.staxex.Base64DataStreamWriteBufferSize");
            if (string != null) {
                n = Integer.parseInt(string);
            }
        }
        catch (Exception exception) {
            logger.log(Level.INFO, "Error reading com.sun.xml.internal.org.jvnet.staxex.Base64DataStreamWriteBufferSize property", exception);
        }
        CHUNK_SIZE = n;
    }

    private final class Base64DataSource
    implements DataSource {
        private Base64DataSource() {
        }

        @Override
        public String getContentType() {
            return Base64Data.this.getMimeType();
        }

        @Override
        public InputStream getInputStream() {
            return new ByteArrayInputStream(Base64Data.this.data, 0, Base64Data.this.dataLen);
        }

        @Override
        public String getName() {
            return null;
        }

        @Override
        public OutputStream getOutputStream() {
            throw new UnsupportedOperationException();
        }
    }

    private final class Base64StreamingDataHandler
    extends StreamingDataHandler {
        Base64StreamingDataHandler(DataSource dataSource) {
            super(dataSource);
        }

        @Override
        public InputStream readOnce() throws IOException {
            return this.getDataSource().getInputStream();
        }

        @Override
        public void moveTo(File file) throws IOException {
            try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                fileOutputStream.write(Base64Data.this.data, 0, Base64Data.this.dataLen);
            }
        }

        @Override
        public void close() throws IOException {
        }
    }

    private static final class FilterDataHandler
    extends StreamingDataHandler {
        FilterDataHandler(DataHandler dataHandler) {
            super(dataHandler.getDataSource());
        }

        @Override
        public InputStream readOnce() throws IOException {
            return this.getDataSource().getInputStream();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void moveTo(File file) throws IOException {
            byte[] byArray = new byte[8192];
            InputStream inputStream = null;
            FileOutputStream fileOutputStream = null;
            try {
                int n;
                inputStream = this.getDataSource().getInputStream();
                fileOutputStream = new FileOutputStream(file);
                while ((n = inputStream.read(byArray)) != -1) {
                    ((OutputStream)fileOutputStream).write(byArray, 0, n);
                }
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                if (fileOutputStream != null) {
                    try {
                        ((OutputStream)fileOutputStream).close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }

        @Override
        public void close() throws IOException {
        }
    }
}

