/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.client.sei;

import com.sun.xml.internal.ws.api.SOAPVersion;
import com.sun.xml.internal.ws.api.message.Attachment;
import com.sun.xml.internal.ws.api.message.AttachmentSet;
import com.sun.xml.internal.ws.api.message.Message;
import com.sun.xml.internal.ws.api.model.ParameterBinding;
import com.sun.xml.internal.ws.api.streaming.XMLStreamReaderFactory;
import com.sun.xml.internal.ws.client.sei.ValueSetter;
import com.sun.xml.internal.ws.client.sei.ValueSetterFactory;
import com.sun.xml.internal.ws.encoding.DataHandlerDataSource;
import com.sun.xml.internal.ws.encoding.StringDataContentHandler;
import com.sun.xml.internal.ws.message.AttachmentUnmarshallerImpl;
import com.sun.xml.internal.ws.model.ParameterImpl;
import com.sun.xml.internal.ws.model.WrapperParameter;
import com.sun.xml.internal.ws.resources.ServerMessages;
import com.sun.xml.internal.ws.spi.db.DatabindingException;
import com.sun.xml.internal.ws.spi.db.PropertyAccessor;
import com.sun.xml.internal.ws.spi.db.RepeatedElementBridge;
import com.sun.xml.internal.ws.spi.db.WrapperComposite;
import com.sun.xml.internal.ws.spi.db.XMLBridge;
import com.sun.xml.internal.ws.streaming.XMLStreamReaderUtil;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.imageio.ImageIO;
import javax.xml.bind.JAXBException;
import javax.xml.bind.attachment.AttachmentUnmarshaller;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.soap.SOAPFaultException;

public abstract class ResponseBuilder {
    protected Map<QName, WrappedPartBuilder> wrappedParts = null;
    protected QName wrapperName;
    public static final ResponseBuilder NONE = new None();
    private static final Map<Class, Object> primitiveUninitializedValues;

    public abstract Object readResponse(Message var1, Object[] var2) throws JAXBException, XMLStreamException;

    protected Object readWrappedResponse(Message message, Object[] objectArray) throws JAXBException, XMLStreamException {
        Object object = null;
        if (!message.hasPayload()) {
            throw new WebServiceException("No payload. Expecting payload with " + this.wrapperName + " element");
        }
        XMLStreamReader xMLStreamReader = message.readPayload();
        XMLStreamReaderUtil.verifyTag(xMLStreamReader, this.wrapperName);
        xMLStreamReader.nextTag();
        while (xMLStreamReader.getEventType() == 1) {
            WrappedPartBuilder wrappedPartBuilder = this.wrappedParts.get(xMLStreamReader.getName());
            if (wrappedPartBuilder == null) {
                XMLStreamReaderUtil.skipElement(xMLStreamReader);
                xMLStreamReader.nextTag();
            } else {
                Object object2 = wrappedPartBuilder.readResponse(objectArray, xMLStreamReader, message.getAttachments());
                if (object2 != null) {
                    assert (object == null);
                    object = object2;
                }
            }
            if (xMLStreamReader.getEventType() == 1 || xMLStreamReader.getEventType() == 2) continue;
            XMLStreamReaderUtil.nextElementContent(xMLStreamReader);
        }
        xMLStreamReader.close();
        XMLStreamReaderFactory.recycle(xMLStreamReader);
        return object;
    }

    public static Object getVMUninitializedValue(Type type) {
        return primitiveUninitializedValues.get(type);
    }

    public static final String getWSDLPartName(Attachment attachment) {
        String string = attachment.getContentId();
        int n = string.lastIndexOf(64, string.length());
        if (n == -1) {
            return null;
        }
        String string2 = string.substring(0, n);
        if ((n = string2.lastIndexOf(61, string2.length())) == -1) {
            return null;
        }
        try {
            return URLDecoder.decode(string2.substring(0, n), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new WebServiceException(unsupportedEncodingException);
        }
    }

    private static boolean isXMLMimeType(String string) {
        return string.equals("text/xml") || string.equals("application/xml");
    }

    static {
        Map<Class, Object> map = primitiveUninitializedValues = new HashMap<Class, Object>();
        map.put(Integer.TYPE, 0);
        map.put(Character.TYPE, Character.valueOf('\u0000'));
        map.put(Byte.TYPE, (byte)0);
        map.put(Short.TYPE, (short)0);
        map.put(Long.TYPE, 0L);
        map.put(Float.TYPE, Float.valueOf(0.0f));
        map.put(Double.TYPE, 0.0);
    }

    public static abstract class AttachmentBuilder
    extends ResponseBuilder {
        protected final ValueSetter setter;
        protected final ParameterImpl param;
        private final String pname;
        private final String pname1;

        AttachmentBuilder(ParameterImpl parameterImpl, ValueSetter valueSetter) {
            this.setter = valueSetter;
            this.param = parameterImpl;
            this.pname = parameterImpl.getPartName();
            this.pname1 = "<" + this.pname;
        }

        public static ResponseBuilder createAttachmentBuilder(ParameterImpl parameterImpl, ValueSetter valueSetter) {
            Class clazz = (Class)parameterImpl.getTypeInfo().type;
            if (DataHandler.class.isAssignableFrom(clazz)) {
                return new DataHandlerBuilder(parameterImpl, valueSetter);
            }
            if (byte[].class == clazz) {
                return new ByteArrayBuilder(parameterImpl, valueSetter);
            }
            if (Source.class.isAssignableFrom(clazz)) {
                return new SourceBuilder(parameterImpl, valueSetter);
            }
            if (Image.class.isAssignableFrom(clazz)) {
                return new ImageBuilder(parameterImpl, valueSetter);
            }
            if (InputStream.class == clazz) {
                return new InputStreamBuilder(parameterImpl, valueSetter);
            }
            if (ResponseBuilder.isXMLMimeType(parameterImpl.getBinding().getMimeType())) {
                return new JAXBBuilder(parameterImpl, valueSetter);
            }
            if (String.class.isAssignableFrom(clazz)) {
                return new StringBuilder(parameterImpl, valueSetter);
            }
            throw new UnsupportedOperationException("Unexpected Attachment type =" + clazz);
        }

        @Override
        public Object readResponse(Message message, Object[] objectArray) throws JAXBException, XMLStreamException {
            for (Attachment attachment : message.getAttachments()) {
                String string = AttachmentBuilder.getWSDLPartName(attachment);
                if (string == null || !string.equals(this.pname) && !string.equals(this.pname1)) continue;
                return this.mapAttachment(attachment, objectArray);
            }
            return null;
        }

        abstract Object mapAttachment(Attachment var1, Object[] var2) throws JAXBException;
    }

    public static final class Body
    extends ResponseBuilder {
        private final XMLBridge<?> bridge;
        private final ValueSetter setter;

        public Body(XMLBridge<?> xMLBridge, ValueSetter valueSetter) {
            this.bridge = xMLBridge;
            this.setter = valueSetter;
        }

        @Override
        public Object readResponse(Message message, Object[] objectArray) throws JAXBException {
            return this.setter.put(message.readPayloadAsJAXB(this.bridge), objectArray);
        }
    }

    private static final class ByteArrayBuilder
    extends AttachmentBuilder {
        ByteArrayBuilder(ParameterImpl parameterImpl, ValueSetter valueSetter) {
            super(parameterImpl, valueSetter);
        }

        @Override
        Object mapAttachment(Attachment attachment, Object[] objectArray) {
            return this.setter.put(attachment.asByteArray(), objectArray);
        }
    }

    public static final class Composite
    extends ResponseBuilder {
        private final ResponseBuilder[] builders;

        public Composite(ResponseBuilder ... responseBuilderArray) {
            this.builders = responseBuilderArray;
        }

        public Composite(Collection<? extends ResponseBuilder> collection) {
            this(collection.toArray(new ResponseBuilder[collection.size()]));
        }

        @Override
        public Object readResponse(Message message, Object[] objectArray) throws JAXBException, XMLStreamException {
            Object object = null;
            for (ResponseBuilder responseBuilder : this.builders) {
                Object object2 = responseBuilder.readResponse(message, objectArray);
                if (object2 == null) continue;
                assert (object == null);
                object = object2;
            }
            return object;
        }
    }

    private static final class DataHandlerBuilder
    extends AttachmentBuilder {
        DataHandlerBuilder(ParameterImpl parameterImpl, ValueSetter valueSetter) {
            super(parameterImpl, valueSetter);
        }

        @Override
        Object mapAttachment(Attachment attachment, Object[] objectArray) {
            return this.setter.put(attachment.asDataHandler(), objectArray);
        }
    }

    public static final class DocLit
    extends ResponseBuilder {
        private final PartBuilder[] parts;
        private final XMLBridge wrapper;
        private boolean dynamicWrapper;

        public DocLit(WrapperParameter wrapperParameter, ValueSetterFactory valueSetterFactory) {
            this.wrapperName = wrapperParameter.getName();
            this.wrapper = wrapperParameter.getXMLBridge();
            Class clazz = (Class)this.wrapper.getTypeInfo().type;
            this.dynamicWrapper = WrapperComposite.class.equals((Object)clazz);
            ArrayList<PartBuilder> arrayList = new ArrayList<PartBuilder>();
            List<ParameterImpl> list = wrapperParameter.getWrapperChildren();
            for (ParameterImpl parameterImpl : list) {
                if (parameterImpl.isIN()) continue;
                QName qName = parameterImpl.getName();
                if (this.dynamicWrapper) {
                    XMLBridge xMLBridge;
                    if (this.wrappedParts == null) {
                        this.wrappedParts = new HashMap();
                    }
                    if ((xMLBridge = parameterImpl.getInlinedRepeatedElementBridge()) == null) {
                        xMLBridge = parameterImpl.getXMLBridge();
                    }
                    this.wrappedParts.put(parameterImpl.getName(), new WrappedPartBuilder(xMLBridge, valueSetterFactory.get(parameterImpl)));
                    continue;
                }
                try {
                    arrayList.add(new PartBuilder(wrapperParameter.getOwner().getBindingContext().getElementPropertyAccessor(clazz, qName.getNamespaceURI(), parameterImpl.getName().getLocalPart()), valueSetterFactory.get(parameterImpl)));
                    assert (parameterImpl.getBinding() == ParameterBinding.BODY);
                }
                catch (JAXBException jAXBException) {
                    throw new WebServiceException(clazz + " do not have a property of the name " + qName, jAXBException);
                }
            }
            this.parts = arrayList.toArray(new PartBuilder[arrayList.size()]);
        }

        @Override
        public Object readResponse(Message message, Object[] objectArray) throws JAXBException, XMLStreamException {
            if (this.dynamicWrapper) {
                return this.readWrappedResponse(message, objectArray);
            }
            Object object = null;
            if (this.parts.length > 0) {
                if (!message.hasPayload()) {
                    throw new WebServiceException("No payload. Expecting payload with " + this.wrapperName + " element");
                }
                XMLStreamReader xMLStreamReader = message.readPayload();
                XMLStreamReaderUtil.verifyTag(xMLStreamReader, this.wrapperName);
                Object t = this.wrapper.unmarshal(xMLStreamReader, (AttachmentUnmarshaller)(message.getAttachments() != null ? new AttachmentUnmarshallerImpl(message.getAttachments()) : null));
                try {
                    for (PartBuilder partBuilder : this.parts) {
                        Object object2 = partBuilder.readResponse(objectArray, t);
                        if (object2 == null) continue;
                        assert (object == null);
                        object = object2;
                    }
                }
                catch (DatabindingException databindingException) {
                    throw new WebServiceException(databindingException);
                }
                xMLStreamReader.close();
                XMLStreamReaderFactory.recycle(xMLStreamReader);
            } else {
                message.consume();
            }
            return object;
        }

        static final class PartBuilder {
            private final PropertyAccessor accessor;
            private final ValueSetter setter;

            public PartBuilder(PropertyAccessor propertyAccessor, ValueSetter valueSetter) {
                this.accessor = propertyAccessor;
                this.setter = valueSetter;
                assert (propertyAccessor != null && valueSetter != null);
            }

            final Object readResponse(Object[] objectArray, Object object) {
                Object v = this.accessor.get(object);
                return this.setter.put(v, objectArray);
            }
        }
    }

    public static final class Header
    extends ResponseBuilder {
        private final XMLBridge<?> bridge;
        private final ValueSetter setter;
        private final QName headerName;
        private final SOAPVersion soapVersion;

        public Header(SOAPVersion sOAPVersion, QName qName, XMLBridge<?> xMLBridge, ValueSetter valueSetter) {
            this.soapVersion = sOAPVersion;
            this.headerName = qName;
            this.bridge = xMLBridge;
            this.setter = valueSetter;
        }

        public Header(SOAPVersion sOAPVersion, ParameterImpl parameterImpl, ValueSetter valueSetter) {
            this(sOAPVersion, parameterImpl.getTypeInfo().tagName, parameterImpl.getXMLBridge(), valueSetter);
            assert (parameterImpl.getOutBinding() == ParameterBinding.HEADER);
        }

        private SOAPFaultException createDuplicateHeaderException() {
            try {
                SOAPFault sOAPFault = this.soapVersion.getSOAPFactory().createFault();
                sOAPFault.setFaultCode(this.soapVersion.faultCodeServer);
                sOAPFault.setFaultString(ServerMessages.DUPLICATE_PORT_KNOWN_HEADER(this.headerName));
                return new SOAPFaultException(sOAPFault);
            }
            catch (SOAPException sOAPException) {
                throw new WebServiceException(sOAPException);
            }
        }

        @Override
        public Object readResponse(Message message, Object[] objectArray) throws JAXBException {
            com.sun.xml.internal.ws.api.message.Header header = null;
            Iterator<com.sun.xml.internal.ws.api.message.Header> iterator = message.getHeaders().getHeaders(this.headerName, true);
            if (iterator.hasNext()) {
                header = iterator.next();
                if (iterator.hasNext()) {
                    throw this.createDuplicateHeaderException();
                }
            }
            if (header != null) {
                return this.setter.put(header.readAsJAXB(this.bridge), objectArray);
            }
            return null;
        }
    }

    private static final class ImageBuilder
    extends AttachmentBuilder {
        ImageBuilder(ParameterImpl parameterImpl, ValueSetter valueSetter) {
            super(parameterImpl, valueSetter);
        }

        @Override
        Object mapAttachment(Attachment attachment, Object[] objectArray) {
            BufferedImage bufferedImage;
            InputStream inputStream = null;
            try {
                inputStream = attachment.asInputStream();
                bufferedImage = ImageIO.read(inputStream);
            }
            catch (IOException iOException) {
                throw new WebServiceException(iOException);
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        throw new WebServiceException(iOException);
                    }
                }
            }
            return this.setter.put(bufferedImage, objectArray);
        }
    }

    private static final class InputStreamBuilder
    extends AttachmentBuilder {
        InputStreamBuilder(ParameterImpl parameterImpl, ValueSetter valueSetter) {
            super(parameterImpl, valueSetter);
        }

        @Override
        Object mapAttachment(Attachment attachment, Object[] objectArray) {
            return this.setter.put(attachment.asInputStream(), objectArray);
        }
    }

    private static final class JAXBBuilder
    extends AttachmentBuilder {
        JAXBBuilder(ParameterImpl parameterImpl, ValueSetter valueSetter) {
            super(parameterImpl, valueSetter);
        }

        @Override
        Object mapAttachment(Attachment attachment, Object[] objectArray) throws JAXBException {
            Object t = this.param.getXMLBridge().unmarshal(attachment.asInputStream());
            return this.setter.put(t, objectArray);
        }
    }

    static final class None
    extends ResponseBuilder {
        private None() {
        }

        @Override
        public Object readResponse(Message message, Object[] objectArray) {
            message.consume();
            return null;
        }
    }

    public static final class NullSetter
    extends ResponseBuilder {
        private final ValueSetter setter;
        private final Object nullValue;

        public NullSetter(ValueSetter valueSetter, Object object) {
            assert (valueSetter != null);
            this.nullValue = object;
            this.setter = valueSetter;
        }

        @Override
        public Object readResponse(Message message, Object[] objectArray) {
            return this.setter.put(this.nullValue, objectArray);
        }
    }

    public static final class RpcLit
    extends ResponseBuilder {
        public RpcLit(WrapperParameter wrapperParameter, ValueSetterFactory valueSetterFactory) {
            assert (wrapperParameter.getTypeInfo().type == WrapperComposite.class);
            this.wrapperName = wrapperParameter.getName();
            this.wrappedParts = new HashMap();
            List<ParameterImpl> list = wrapperParameter.getWrapperChildren();
            for (ParameterImpl parameterImpl : list) {
                this.wrappedParts.put(parameterImpl.getName(), new WrappedPartBuilder(parameterImpl.getXMLBridge(), valueSetterFactory.get(parameterImpl)));
                assert (parameterImpl.getBinding() == ParameterBinding.BODY);
            }
        }

        @Override
        public Object readResponse(Message message, Object[] objectArray) throws JAXBException, XMLStreamException {
            return this.readWrappedResponse(message, objectArray);
        }
    }

    private static final class SourceBuilder
    extends AttachmentBuilder {
        SourceBuilder(ParameterImpl parameterImpl, ValueSetter valueSetter) {
            super(parameterImpl, valueSetter);
        }

        @Override
        Object mapAttachment(Attachment attachment, Object[] objectArray) {
            return this.setter.put(attachment.asSource(), objectArray);
        }
    }

    private static final class StringBuilder
    extends AttachmentBuilder {
        StringBuilder(ParameterImpl parameterImpl, ValueSetter valueSetter) {
            super(parameterImpl, valueSetter);
        }

        @Override
        Object mapAttachment(Attachment attachment, Object[] objectArray) {
            attachment.getContentType();
            StringDataContentHandler stringDataContentHandler = new StringDataContentHandler();
            try {
                String string = (String)stringDataContentHandler.getContent(new DataHandlerDataSource(attachment.asDataHandler()));
                return this.setter.put(string, objectArray);
            }
            catch (Exception exception) {
                throw new WebServiceException(exception);
            }
        }
    }

    static final class WrappedPartBuilder {
        private final XMLBridge bridge;
        private final ValueSetter setter;

        public WrappedPartBuilder(XMLBridge xMLBridge, ValueSetter valueSetter) {
            this.bridge = xMLBridge;
            this.setter = valueSetter;
        }

        final Object readResponse(Object[] objectArray, XMLStreamReader xMLStreamReader, AttachmentSet attachmentSet) throws JAXBException {
            Object object;
            AttachmentUnmarshallerImpl attachmentUnmarshallerImpl;
            AttachmentUnmarshallerImpl attachmentUnmarshallerImpl2 = attachmentUnmarshallerImpl = attachmentSet != null ? new AttachmentUnmarshallerImpl(attachmentSet) : null;
            if (this.bridge instanceof RepeatedElementBridge) {
                RepeatedElementBridge repeatedElementBridge = (RepeatedElementBridge)this.bridge;
                ArrayList arrayList = new ArrayList();
                QName qName = xMLStreamReader.getName();
                while (xMLStreamReader.getEventType() == 1 && qName.equals(xMLStreamReader.getName())) {
                    arrayList.add(repeatedElementBridge.unmarshal(xMLStreamReader, (AttachmentUnmarshaller)attachmentUnmarshallerImpl));
                    XMLStreamReaderUtil.toNextTag(xMLStreamReader, qName);
                }
                object = repeatedElementBridge.collectionHandler().convert(arrayList);
            } else {
                object = this.bridge.unmarshal(xMLStreamReader, (AttachmentUnmarshaller)attachmentUnmarshallerImpl);
            }
            return this.setter.put(object, objectArray);
        }
    }
}

