/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.policy.jaxws;

import com.sun.xml.internal.ws.api.policy.ModelTranslator;
import com.sun.xml.internal.ws.policy.Policy;
import com.sun.xml.internal.ws.policy.PolicyException;
import com.sun.xml.internal.ws.policy.PolicyMapExtender;
import com.sun.xml.internal.ws.policy.PolicySubject;
import com.sun.xml.internal.ws.policy.privateutil.PolicyLogger;
import com.sun.xml.internal.ws.policy.sourcemodel.PolicySourceModel;
import com.sun.xml.internal.ws.resources.PolicyMessages;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

abstract class BuilderHandler {
    private static final PolicyLogger LOGGER = PolicyLogger.getLogger(BuilderHandler.class);
    Map<String, PolicySourceModel> policyStore;
    Collection<String> policyURIs;
    Object policySubject;

    BuilderHandler(Collection<String> collection, Map<String, PolicySourceModel> map, Object object) {
        this.policyStore = map;
        this.policyURIs = collection;
        this.policySubject = object;
    }

    final void populate(PolicyMapExtender policyMapExtender) throws PolicyException {
        if (null == policyMapExtender) {
            throw LOGGER.logSevereException(new PolicyException(PolicyMessages.WSP_1006_POLICY_MAP_EXTENDER_CAN_NOT_BE_NULL()));
        }
        this.doPopulate(policyMapExtender);
    }

    protected abstract void doPopulate(PolicyMapExtender var1) throws PolicyException;

    final Collection<Policy> getPolicies() throws PolicyException {
        if (null == this.policyURIs) {
            throw LOGGER.logSevereException(new PolicyException(PolicyMessages.WSP_1004_POLICY_URIS_CAN_NOT_BE_NULL()));
        }
        if (null == this.policyStore) {
            throw LOGGER.logSevereException(new PolicyException(PolicyMessages.WSP_1010_NO_POLICIES_DEFINED()));
        }
        ArrayList<Policy> arrayList = new ArrayList<Policy>(this.policyURIs.size());
        for (String string : this.policyURIs) {
            PolicySourceModel policySourceModel = this.policyStore.get(string);
            if (policySourceModel == null) {
                throw LOGGER.logSevereException(new PolicyException(PolicyMessages.WSP_1005_POLICY_REFERENCE_DOES_NOT_EXIST(string)));
            }
            arrayList.add(ModelTranslator.getTranslator().translate(policySourceModel));
        }
        return arrayList;
    }

    final Collection<PolicySubject> getPolicySubjects() throws PolicyException {
        Collection<Policy> collection = this.getPolicies();
        ArrayList<PolicySubject> arrayList = new ArrayList<PolicySubject>(collection.size());
        for (Policy policy : collection) {
            arrayList.add(new PolicySubject(this.policySubject, policy));
        }
        return arrayList;
    }
}

