/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.liveconnect;

import java.io.IOException;
import sun.plugin2.liveconnect.BrowserSideObject;
import sun.plugin2.liveconnect.RemoteJavaObject;
import sun.plugin2.message.Serializer;

public final class ArgumentHelper {
    private static final int NULL_TAG = 0;
    private static final int STRING_TAG = 1;
    private static final int BOOLEAN_TAG = 2;
    private static final int BYTE_TAG = 3;
    private static final int CHARACTER_TAG = 4;
    private static final int SHORT_TAG = 5;
    private static final int INTEGER_TAG = 6;
    private static final int LONG_TAG = 7;
    private static final int FLOAT_TAG = 8;
    private static final int DOUBLE_TAG = 9;
    private static final int BROWSER_SIDE_OBJECT_TAG = 10;
    private static final int REMOTE_JAVA_OBJECT_TAG = 11;

    private ArgumentHelper() {
    }

    public static boolean isPrimitiveOrString(Object object) {
        if (object instanceof String) {
            return true;
        }
        return ArgumentHelper.isPrimitive(object);
    }

    public static boolean isPrimitive(Object object) {
        return object instanceof Boolean || object instanceof Byte || object instanceof Character || object instanceof Short || object instanceof Integer || object instanceof Long || object instanceof Float || object instanceof Double;
    }

    public static void validate(Object[] objectArray) throws IllegalArgumentException {
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                ArgumentHelper.validate(objectArray[i]);
            }
        }
    }

    public static void writeObject(Serializer serializer, Object object) throws IOException {
        if (object == null) {
            serializer.writeByte((byte)0);
            return;
        }
        if (object instanceof String) {
            serializer.writeByte((byte)1);
            serializer.writeUTF((String)object);
        } else if (object instanceof Boolean) {
            serializer.writeByte((byte)2);
            serializer.writeBoolean((Boolean)object);
        } else if (object instanceof Byte) {
            serializer.writeByte((byte)3);
            serializer.writeByte((Byte)object);
        } else if (object instanceof Character) {
            serializer.writeByte((byte)4);
            serializer.writeChar(((Character)object).charValue());
        } else if (object instanceof Short) {
            serializer.writeByte((byte)5);
            serializer.writeShort((Short)object);
        } else if (object instanceof Integer) {
            serializer.writeByte((byte)6);
            serializer.writeInt((Integer)object);
        } else if (object instanceof Long) {
            serializer.writeByte((byte)7);
            serializer.writeLong((Long)object);
        } else if (object instanceof Float) {
            serializer.writeByte((byte)8);
            serializer.writeFloat(((Float)object).floatValue());
        } else if (object instanceof Double) {
            serializer.writeByte((byte)9);
            serializer.writeDouble((Double)object);
        } else if (object instanceof BrowserSideObject) {
            serializer.writeByte((byte)10);
            serializer.writeLong(((BrowserSideObject)object).getNativeObjectReference());
        } else if (object instanceof RemoteJavaObject) {
            serializer.writeByte((byte)11);
            RemoteJavaObject.write(serializer, (RemoteJavaObject)object);
        } else {
            throw new RuntimeException("Can't serialize objects of type " + object.getClass().getName());
        }
    }

    public static Object readObject(Serializer serializer) throws IOException {
        int n = serializer.readByte() & 0xFF;
        switch (n) {
            case 0: {
                return null;
            }
            case 1: {
                return serializer.readUTF();
            }
            case 2: {
                return serializer.readBoolean() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 3: {
                return new Byte(serializer.readByte());
            }
            case 4: {
                return new Character(serializer.readChar());
            }
            case 5: {
                return new Short(serializer.readShort());
            }
            case 6: {
                return new Integer(serializer.readInt());
            }
            case 7: {
                return new Long(serializer.readLong());
            }
            case 8: {
                return new Float(serializer.readFloat());
            }
            case 9: {
                return new Double(serializer.readDouble());
            }
            case 10: {
                return new BrowserSideObject(serializer.readLong());
            }
            case 11: {
                return RemoteJavaObject.read(serializer);
            }
        }
        throw new RuntimeException("Unexpected object tag " + n);
    }

    public static void writeObjectArray(Serializer serializer, Object[] objectArray) throws IOException {
        if (objectArray == null) {
            serializer.writeBoolean(false);
            return;
        }
        serializer.writeBoolean(true);
        serializer.writeInt(objectArray.length);
        for (int i = 0; i < objectArray.length; ++i) {
            ArgumentHelper.writeObject(serializer, objectArray[i]);
        }
    }

    public static Object[] readObjectArray(Serializer serializer) throws IOException {
        if (!serializer.readBoolean()) {
            return null;
        }
        int n = serializer.readInt();
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            objectArray[i] = ArgumentHelper.readObject(serializer);
        }
        return objectArray;
    }

    private static void validate(Object object) throws IllegalArgumentException {
        if (object == null) {
            return;
        }
        if (ArgumentHelper.isPrimitiveOrString(object)) {
            return;
        }
        if (object instanceof BrowserSideObject) {
            return;
        }
        if (object instanceof RemoteJavaObject) {
            return;
        }
        throw new IllegalArgumentException("Can't pass instances of class " + object.getClass().getName() + " between JVMs");
    }
}

