;   Copyright (C) 2016 Free Software Foundation, Inc.
;   Contributed by Alex Panek.
;
; This file is free software; you can redistribute it and/or modify it
; under the terms of the GNU General Public License as published by the
; Free Software Foundation; either version 3, or (at your option) any
; later version.
;
; This file is distributed in the hope that it will be useful, but
; WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
; General Public License for more details.
;
; Under Section 7 of GPL version 3, you are granted additional
; permissions described in the GCC Runtime Library Exception, version
; 3.1, as published by the Free Software Foundation.
;
; You should have received a copy of the GNU General Public License and
; a copy of the GCC Runtime Library Exception along with this program;
; see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see
; <http://www.gnu.org/licenses/>.


#include "vregs.h"

    .text


#ifdef __RL78_MUL_NONE__

; inputs:   AX  = signed 16 bit value
;           BC  = signed 16 bit value
; output:   BC:AX = the 32-bit signed product of the two inputs
; clobbers: DE
START_FUNC ___mulhisi3

    bt     a.7, $2f   ; is the 1st operand negative?

; inputs:   AX  = unsigned 16 bit value
;           BC  = signed 16 bit value
; output:   BC:AX = the 32-bit signed product of the two inputs
; clobbers: DE
START_ANOTHER_FUNC ___usmulhisi3

    bt     r_3.7, $1f  ; is the 2nd operand negative?

; inputs:   AX  = unsigned 16 bit value
;           BC  = unsigned 16 bit value
; output:   BC:AX = the 32-bit unsigned product of the two inputs
; clobbers: DE
START_ANOTHER_FUNC ___umulhisi3  ; ~43 clocks on the S1 core

    push   hl
                          ; AX=A|B   BC=C|D
    xch    a, c           ; AX=D|B   BC=C|A
    movw   de, ax         ; AX=D|B   BC=C|A   DE=D|B
    mulu   x              ; AX=BxD   BC=C|A   DE=D|B
    xchw   ax, bc         ; AX=C|A   BC=BxD   DE=D|B
    movw   hl, ax         ; AX=C|A   BC=BxD   DE=D|B   HL=C|A
    mulu   x              ; AX=AxC   BC=BxD   DE=D|B   HL=C|A

#if 0
    xchw   ax, de
    xch    a, h
    mulu   x
    xchw   ax, hl
    mulu   x
    xch    a, x
    add    a, b
    xch    a, x
    addc   a, #0
    addw   ax, hl
    xch    a, x
    mov    b, a
    clrb   a
    addc   a, #0           ; alternatively, rolc a, 1
    addw   ax, de
    xchw   ax, bc
#else
    xch    a, b           ; AX=BC|ac BC=AC|bd DE=D|B   HL=C|A
    xch    a, x           ; AX=ac|BC BC=AC|bd DE=D|B   HL=C|A
    xchw   ax, de         ; AX=D|B   BC=AC|bd DE=acc   HL=C|A
    xch    a, h           ; AX=C|B   BC=AC|bd DE=acc   HL=D|A
    mulu   x              ; AX=BC    BC=AC|bd DE=acc   HL=D|A
    addw   ax, de         ; AX=acc   BC=AC|bd          HL=D|A
    sknc
    inc    b
    xchw   ax, hl         ; AX=D|A   BC=AC|bd          HL=acc
    mulu   x              ; AX=AD    BC=AC|bd          HL=acc
    addw   ax, hl         ; AX=acc   BC=AC|bd
    sknc
    inc    b
    xch    a, c           ; BC has the highest 2 bytes (correct order)
    xch    a, x           ; AX has them swapped so corect that
#endif

    pop    hl
    ret

END_ANOTHER_FUNC ___umulhisi3

1:  push   ax              ; save the 1st operand on the stack
    call   $!___umulhisi3  ; call the uint16_t x uint16_t routine
    br     $3f

2:  push   bc              ; save the 2nd operand on the stack
    call   $!___usmulhisi3 ; call the uint16_t x int16_t routine
3:  pop    de              ; get the operand value in DE
    xchw   ax, bc          ; subtract it from the upper 16-bits
    subw   ax, de          ; of the result (in BC registers)
    xchw   ax, bc
    ret


END_ANOTHER_FUNC ___usmulhisi3

END_FUNC ___mulhisi3

#endif /* __RL78_MUL_NONE__ */


#ifdef __RL78_MUL_G13__

; inputs:   AX  = unsigned 16 bit value
;           BC  = unsigned 16 bit value
; output:   BC:AX = the 32-bit unsigned product of the two inputs
; clobbers: -
START_FUNC ___mulhisi3
    mov    !MDUC, #8       ; signed multiply operation
    br     $0f

; inputs:   AX  = signed 16 bit value
;           BC  = signed 16 bit value
; output:   BC:AX = the 32-bit unsigned product of the two inputs
; clobbers: -
START_ANOTHER_FUNC ___umulhisi3

    mov    !MDUC, #0       ; unsigned multiply operation
0:  movw   MDAL, ax
    movw   ax, bc
    movw   MDAH, ax
    nop                    ; MDBH:MDBL = MDAL * MDAH
    movw   ax, MDBH
    movw   bc, ax
    movw   ax, MDBL
    ret

END_ANOTHER_FUNC ___umulhisi3

END_FUNC ___mulhisi3

; inputs:   AX  = unsigned 16 bit value
;           BC  = signed 16 bit value
; output:   BC:AX = the 32-bit signed product of the two inputs
; clobbers: -
START_FUNC ___usmulhisi3

    mov    !MDUC, #0       ; unsigned multiply operation
    movw   MDAL, ax
    xchw   ax, bc          ; second op in AX, first saved in BC
    movw   MDAH, ax
    mov1   CY, a.7         ; get the sign bit into CY; MDBH:MDBL = MDAL * MDAH
    movw   ax, MDBH
    sknc
    subw   ax, bc          ; subtract 1st op from upper word of result
    movw   bc, ax          ; if the second op was negative
    movw   ax, MDBL
    ret

END_FUNC ___usmulhisi3

#endif /* __RL78_MUL_G13__ */


#ifdef __RL78_MUL_G14__

; inputs:   AX  = unsigned 16 bit value
;           BC  = signed 16 bit value
; output:   BC:AX = the 32-bit signed product of the two inputs
; clobbers: DE
START_FUNC ___usmulhisi3

    bt     r_3.7, $0f
    mulhu
    ret

0:  movw   de, ax
    mulhu
    xchw   ax, bc
    subw   ax, de          ; subtract it from the upper part/word of the result
    xchw   ax, bc
    ret

END_FUNC ___usmulhisi3

#endif /* __RL78_MUL_G14__ */

