// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*! 
 * @file BatteryState.h
 * This header file contains the declaration of the described types in the IDL file.
 *
 * This file was generated by the tool gen.
 */

#ifndef _BatteryState_H_
#define _BatteryState_H_

#ifdef __cplusplus
extern "C"
{
#endif

#include <stdint.h>
#include <stdbool.h>
#include "Header.h"




/*!
 * @brief This struct represents the structure BatteryState defined by the user in the IDL file.
 * @ingroup BATTERYSTATE
 */
typedef struct BatteryState
{
    Header header;
    float voltage;
    float current;
    float charge;
    float capacity;
    float design_capacity;
    float percentage;
    uint8_t power_supply_status;
    uint8_t power_supply_health;
    uint8_t power_supply_technology;
    bool present;
    float cell_voltage[10];
    uint32_t cell_voltage_size;
    uint8_t location[32];
    uint8_t serial_number[32];
} BatteryState;

struct ucdrBuffer;

bool BatteryState_serialize_topic(struct ucdrBuffer* writer, const BatteryState* topic);
bool BatteryState_deserialize_topic(struct ucdrBuffer* reader, BatteryState* topic);
uint32_t BatteryState_size_of_topic(const BatteryState* topic, uint32_t size);


#ifdef __cplusplus
}
#endif

#endif // _BatteryState_H_