;   Copyright (C) 2016 Free Software Foundation, Inc.
;   Contributed by Alex Panek.
;
; This file is free software; you can redistribute it and/or modify it
; under the terms of the GNU General Public License as published by the
; Free Software Foundation; either version 3, or (at your option) any
; later version.
;
; This file is distributed in the hope that it will be useful, but
; WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
; General Public License for more details.
;
; Under Section 7 of GPL version 3, you are granted additional
; permissions described in the GCC Runtime Library Exception, version
; 3.1, as published by the Free Software Foundation.
;
; You should have received a copy of the GNU General Public License and
; a copy of the GCC Runtime Library Exception along with this program;
; see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see
; <http://www.gnu.org/licenses/>.


#include "vregs.h"

    .text

; DE - input:  address of the 1st source string
; HL - input:  address of the 2nd source string
; AX - input:  maximum number of chars to compare (from each string)
;      output: result of comparison

; [de] = 0, [hl] > 0               => res < 0 STOP  *
; [de] = 0, [hl] = 0               => res = 0 STOP
; [de] > 0, [hl] = 0               => res > 0 STOP  *
; [de] > 0, [hl] > 0, [de] == [hl] => CONT
; [de] > 0, [hl] > 0, [de] != [hl] => res != 0 STOP *


START_FUNC ___cmpstrnhi

    push  bc
    push  de
    push  hl

    addw  ax, de
    movw  bc, ax  ; end of the 1st source buffer
    br    $1f     ; need to support zero-length?

0:  mov   a, [de]
    sub   a, [hl]
    bnz   $2f     ; different characters (one may be NUL)

    cmp   a, [hl] ; were both NUL?
    bz    $2f

    incw  de      ; advance in both strings
    incw  hl

    movw  ax, bc  ; check the bounds using the pos in 1st string
1:  subw  ax, de
    bnz   $0b     ; limit not reached => continue

2:  sarw  ax, 8   ; sign-extend to 16 bits

    pop   hl
    pop   de
    pop   bc

    ret

END_FUNC ___cmpstrnhi
