#include <Arduino.h>
#include <MsTimer2.h>
#include <WavMp3p.h>
#include <SD.h>

#define LED_ON		HIGH
#define LED_OFF		LOW

#define SW_PAUSE	5
#define SW_SKIP		4
#define SW_ON		0
#define SW_OFF		1

WavMp3p wavmp3p(44100);

void cyclic_handler(void);

void setup() {
	Serial.begin(9600);
	Serial.println("wav & mp3 player");

	pinMode(PIN_LED0, OUTPUT);
	digitalWrite(PIN_LED0, LED_ON);

	while (!SD.begin()) {
		Serial.println("Card failed, or not present.");
		digitalWrite(PIN_LED0, LED_OFF);
		delay(1000);
		digitalWrite(PIN_LED0, LED_ON);
	}

	pinMode(SW_PAUSE, INPUT_PULLUP);
	pinMode(SW_SKIP, INPUT_PULLUP);

	MsTimer2::set(100, cyclic_handler);
	MsTimer2::start();

	wavmp3p.setVolume(0.5);
}

void loop() {
	static File root = SD.open("/");
	while(1){
		File entry = root.openNextFile();
		if (!entry) {
			// no more files
			break;
		}
		Serial.print(entry.name());
		if (entry.isDirectory()) {
			Serial.print("/");
		} else {
			Serial.println();
			wavmp3p.play(entry.name());
		}
		entry.close();
	}
	root.rewindDirectory();
	Serial.println("done!");
	delay(500);
}

void cyclic_handler() {
	static int ct_pause = 0;

	if (SW_ON == digitalRead(SW_PAUSE)) {
		if (ct_pause == 2) {
			if (wavmp3p.read_pause()) {
				wavmp3p.pause(0);
				digitalWrite(PIN_LED0, LED_ON);
			} else {
				wavmp3p.pause(1);
				digitalWrite(PIN_LED0, LED_OFF);
			}
			ct_pause++;
		} else if (ct_pause < 2) {
			ct_pause++;
		}
	} else {
		ct_pause = 0;
	}

	static int ct_skip = 0;

	if (SW_ON == digitalRead(SW_SKIP)) {
		if (ct_skip == 2) {
			wavmp3p.skip();
			digitalWrite(PIN_LED0, LED_ON);
			ct_skip++;
		} else if (ct_skip < 2) {
			ct_skip++;
		}
	} else {
		ct_skip = 0;
	}
}
