// Sample program for GR-LYCHEE and GR-PEACH
// Display camera image after drawing on LCD
// Public domain

#include <Arduino.h>
#include <Camera.h>
#include <LCD.h>
#include <opencv.hpp>

#define IMAGE_HW 480
#define IMAGE_VW 272
Camera camera(IMAGE_HW, IMAGE_VW);
LCD lcd(IMAGE_HW, IMAGE_VW);
static uint8_t lcd_buf[BYTE_PER_PIXEL_YUV * IMAGE_HW * IMAGE_VW];

using namespace cv;

void setup() {
  camera.begin();
  lcd.begin(lcd_buf, IMAGE_HW, IMAGE_VW);
  lcd.clear();
}

void loop() {
  static int x = 0, y = 0, ax = 10, ay = 10;
  Scalar red(0, 0, 255), green(0, 255, 0), blue(255, 0, 0);
  Scalar yellow = red + green;
  Scalar white = Scalar::all(255);
  Scalar pink = Scalar(154, 51, 255);

  Mat src;
  Mat img_raw(IMAGE_VW, IMAGE_HW, CV_8UC2, camera.getImageAdr());
  cvtColor(img_raw, src, COLOR_YUV2BGR_YUYV); //covert YUV to RGB

  x += ax;
  y += ay;
  if (x > (src.cols - 10) || x < 10) {
    ax *= -1;
  }
  if (y > (src.rows - 10) || y < 10) {
    ay *= -1;
  }

  line(src, Point(10, 10), Point(src.cols - 10, 10), blue, 3, LINE_AA); //Line
  line(src, Point(10, src.rows - 10), Point(src.cols - 10, src.rows - 10),
  blue, 3, LINE_AA); //Line
  rectangle(src, Point(10, 30), Point(src.cols - 10, 60), white, FILLED);
  putText(src, "Gadget Renesas", Point(15, 55), FONT_HERSHEY_COMPLEX, 1,
  pink, 2);
  circle(src, Point(x, y), 10, yellow, FILLED);

  stringstream ss;
  ss << x << ", " << y;
  putText(src, ss.str(), Point(10, src.rows - 20),
  FONT_HERSHEY_SCRIPT_SIMPLEX, 1, white, 1);

  lcd.BGR2YUV(src.data, lcd_buf, IMAGE_HW, IMAGE_VW);
  delay(1);
}


