/*****************************************************************************
  ML8511A.cpp

 Copyright (c) 2016 ROHM Co.,Ltd.

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in
 all copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
******************************************************************************/
#include <avr/pgmspace.h>
#include <Arduino.h>
#include <ML8511A.h>

ML8511A::ML8511A(void)
{

}

void ML8511A::init(int ana_pin)
{
  _analog_pin  = ana_pin;
}

void ML8511A::get_rawval(unsigned short *data)
{
  *data = analogRead(_analog_pin);
}

void ML8511A::get_val(float *data)
{
  unsigned short rawdata;

  get_rawval(&rawdata);
  *data = convert_uv(rawdata);
}

// Calculations for UV Sensor - ML8511
// Known Point = 2.2V @ 10mW/cm2, 1V @ 0mW/cm2
// Math:  ADC_Voltage = sensorValue * (5V/1024)
//        UV Intensity = 25 * (ADC_Voltage - 1) / 3   //Conver to UV
float ML8511A::convert_uv(unsigned short data)
{
  float uv;

  uv = (float)data * 5 / 1024;
  uv = 25 * (uv - 1) / 3;

  if (uv < 0) {
    uv = 0;
  }

  return (uv);
}
